/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropForeignKeyTask;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class RenameColumnTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(RenameColumnTask.class);
    private String myOldName;
    private String myNewName;
    private boolean myIsOkayIfNeitherColumnExists;
    private boolean myDeleteTargetColumnFirstIfBothExist;
    private boolean mySimulateMySQLForTest = false;

    public RenameColumnTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    public void setDeleteTargetColumnFirstIfBothExist(boolean theDeleteTargetColumnFirstIfBothExist) {
        this.myDeleteTargetColumnFirstIfBothExist = theDeleteTargetColumnFirstIfBothExist;
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Rename column " + this.myOldName + " to " + this.myNewName + " on table " + this.getTableName());
    }

    public void setOldName(String theOldName) {
        Validate.notBlank((CharSequence)theOldName);
        this.myOldName = theOldName;
    }

    public void setNewName(String theNewName) {
        Validate.notBlank((CharSequence)theNewName);
        this.myNewName = theNewName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doExecute() throws SQLException {
        String notNull;
        String existingType;
        Set<String> columnNames = JdbcUtils.getColumnNames(this.getConnectionProperties(), this.getTableName());
        boolean haveOldName = columnNames.contains(this.myOldName.toUpperCase());
        boolean haveNewName = columnNames.contains(this.myNewName.toUpperCase());
        if (haveOldName && haveNewName) {
            if (!this.myDeleteTargetColumnFirstIfBothExist) throw new SQLException(Msg.code((int)55) + "Can not rename " + this.getTableName() + "." + this.myOldName + " to " + this.myNewName + " because both columns exist!");
            Integer rowsWithData = (Integer)this.getConnectionProperties().getTxTemplate().execute(t -> {
                String sql = "SELECT * FROM " + this.getTableName() + " WHERE " + this.myNewName + " IS NOT NULL";
                JdbcTemplate jdbcTemplate = this.getConnectionProperties().newJdbcTemplate();
                jdbcTemplate.setMaxRows(1);
                return jdbcTemplate.query(sql, (RowMapper)new ColumnMapRowMapper()).size();
            });
            if (rowsWithData != null && rowsWithData > 0) {
                throw new SQLException(Msg.code((int)54) + "Can not rename " + this.getTableName() + "." + this.myOldName + " to " + this.myNewName + " because both columns exist and data exists in " + this.myNewName);
            }
            if (this.getDriverType().equals((Object)DriverTypeEnum.MYSQL_5_7) || this.mySimulateMySQLForTest) {
                this.logInfo(ourLog, "Table {} has columns {} and {} - Going to drop any foreign keys depending on column {} before renaming", this.getTableName(), this.myOldName, this.myNewName, this.myNewName);
                Set<String> foreignKeys = JdbcUtils.getForeignKeysForColumn(this.getConnectionProperties(), this.myNewName, this.getTableName());
                if (foreignKeys != null) {
                    for (String foreignKey : foreignKeys) {
                        List<String> dropFkSqls = DropForeignKeyTask.generateSql(this.getTableName(), foreignKey, this.getDriverType());
                        for (String dropFkSql : dropFkSqls) {
                            this.executeSql(this.getTableName(), dropFkSql, new Object[0]);
                        }
                    }
                }
            }
            this.logInfo(ourLog, "Table {} has columns {} and {} - Going to drop {} before renaming", this.getTableName(), this.myOldName, this.myNewName, this.myNewName);
            String sql = DropColumnTask.createSql(this.getTableName(), this.myNewName);
            this.executeSql(this.getTableName(), sql, new Object[0]);
        } else {
            if (!haveOldName && !haveNewName) {
                if (!this.isOkayIfNeitherColumnExists()) throw new SQLException(Msg.code((int)56) + "Can not rename " + this.getTableName() + "." + this.myOldName + " to " + this.myNewName + " because neither column exists!");
                return;
            }
            if (haveNewName) {
                this.logInfo(ourLog, "Column {} already exists on table {} - No action performed", this.myNewName, this.getTableName());
                return;
            }
        }
        try {
            JdbcUtils.ColumnType existingColumnType = JdbcUtils.getColumnType(this.getConnectionProperties(), this.getTableName(), this.myOldName);
            existingType = this.getSqlType(existingColumnType.getColumnTypeEnum(), existingColumnType.getLength());
            notNull = JdbcUtils.isColumnNullable(this.getConnectionProperties(), this.getTableName(), this.myOldName) ? " null " : " not null";
        }
        catch (SQLException e) {
            throw new InternalErrorException(Msg.code((int)57) + e);
        }
        String sql = this.buildRenameColumnSqlStatement(existingType, notNull);
        this.logInfo(ourLog, "Renaming column {} on table {} to {}", this.myOldName, this.getTableName(), this.myNewName);
        this.executeSql(this.getTableName(), sql, new Object[0]);
    }

    String buildRenameColumnSqlStatement(String theExistingType, String theExistingNotNull) {
        String sql;
        switch (this.getDriverType()) {
            case DERBY_EMBEDDED: {
                sql = "RENAME COLUMN " + this.getTableName() + "." + this.myOldName + " TO " + this.myNewName;
                break;
            }
            case MYSQL_5_7: 
            case MARIADB_10_1: {
                sql = "ALTER TABLE " + this.getTableName() + " CHANGE COLUMN `" + this.myOldName + "` `" + this.myNewName + "` " + theExistingType + " " + theExistingNotNull;
                break;
            }
            case POSTGRES_9_4: 
            case ORACLE_12C: {
                sql = "ALTER TABLE " + this.getTableName() + " RENAME COLUMN " + this.myOldName + " TO " + this.myNewName;
                break;
            }
            case MSSQL_2012: {
                sql = "sp_rename '" + this.getTableName() + "." + this.myOldName + "', '" + this.myNewName + "', 'COLUMN'";
                break;
            }
            case H2_EMBEDDED: {
                sql = "ALTER TABLE " + this.getTableName() + " ALTER COLUMN " + this.myOldName + " RENAME TO " + this.myNewName;
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)58));
            }
        }
        return sql;
    }

    public boolean isOkayIfNeitherColumnExists() {
        return this.myIsOkayIfNeitherColumnExists;
    }

    public void setOkayIfNeitherColumnExists(boolean theOkayIfNeitherColumnExists) {
        this.myIsOkayIfNeitherColumnExists = theOkayIfNeitherColumnExists;
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myOldName);
        theBuilder.append((Object)this.myNewName);
    }

    @VisibleForTesting
    void setSimulateMySQLForTest(boolean theSimulateMySQLForTest) {
        this.mySimulateMySQLForTest = theSimulateMySQLForTest;
    }
}

