/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigratePostgresTextClobToBinaryClobTask
extends BaseTableColumnTask {
    private static final Logger ourLog = LoggerFactory.getLogger(MigratePostgresTextClobToBinaryClobTask.class);

    public MigratePostgresTextClobToBinaryClobTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Migrate text clob " + this.getColumnName() + " from table " + this.getTableName() + " (only affects Postgresql)");
    }

    @Override
    protected void doExecute() throws SQLException {
        if (this.getConnectionProperties().getDriverType() != DriverTypeEnum.POSTGRES_9_4) {
            return;
        }
        String tableName = this.getTableName();
        String columnName = this.getColumnName();
        JdbcUtils.ColumnType columnType = JdbcUtils.getColumnType(this.getConnectionProperties(), tableName, columnName);
        if (columnType.getColumnTypeEnum() == ColumnTypeEnum.LONG) {
            ourLog.info("Table {} column {} is already of type LONG, no migration needed", (Object)tableName, (Object)columnName);
            return;
        }
        String tempColumnName = columnName + "_m".toLowerCase();
        tableName = tableName.toLowerCase();
        columnName = columnName.toLowerCase();
        this.executeSql(tableName, "alter table " + tableName + " add column " + tempColumnName + " oid", new Object[0]);
        this.executeSql(tableName, "update " + tableName + " set " + tempColumnName + " = cast(" + columnName + " as oid) where " + columnName + " is not null", new Object[0]);
        this.executeSql(tableName, "alter table " + tableName + " drop column " + columnName, new Object[0]);
        this.executeSql(tableName, "alter table " + tableName + " rename column " + tempColumnName + " to " + columnName, new Object[0]);
    }
}

