/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropForeignKeyTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropIndexTask;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(DropTableTask.class);

    public DropTableTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Drop table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> tableNames = JdbcUtils.getTableNames(this.getConnectionProperties());
        if (!tableNames.contains(this.getTableName())) {
            return;
        }
        Set<String> foreignKeys = JdbcUtils.getForeignKeys(this.getConnectionProperties(), null, this.getTableName());
        this.logInfo(ourLog, "Table {} has the following foreign keys: {}", this.getTableName(), foreignKeys);
        Set<String> indexNames = JdbcUtils.getIndexNames(this.getConnectionProperties(), this.getTableName());
        this.logInfo(ourLog, "Table {} has the following indexes: {}", this.getTableName(), indexNames);
        for (String string : foreignKeys) {
            List<String> sql = DropForeignKeyTask.generateSql(this.getTableName(), string, this.getDriverType());
            for (String nextSql : sql) {
                this.executeSql(this.getTableName(), nextSql, new Object[0]);
            }
        }
        DropIndexTask theIndexTask = new DropIndexTask(this.getProductVersion(), this.getSchemaVersion());
        theIndexTask.setTableName(this.getTableName()).setConnectionProperties(this.getConnectionProperties()).setDriverType(this.getDriverType()).setDryRun(this.isDryRun());
        for (String nextIndex : indexNames) {
            theIndexTask.setIndexName(nextIndex).execute();
        }
        this.logInfo(ourLog, "Dropping table: {}", this.getTableName());
        String string = "DROP TABLE " + this.getTableName();
        this.executeSql(this.getTableName(), string, new Object[0]);
    }
}

