/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.tracing.xray;

import ca.nexapp.tracing.Trace;
import ca.nexapp.tracing.Tracer;
import ca.nexapp.tracing.xray.XRay;
import ca.nexapp.tracing.xray.XRayTrace;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Subsegment;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lca/nexapp/tracing/xray/XRayTracer;", "Lca/nexapp/tracing/Tracer;", "recorder", "Lcom/amazonaws/xray/AWSXRayRecorder;", "(Lcom/amazonaws/xray/AWSXRayRecorder;)V", "createSubsegment", "Lcom/amazonaws/xray/entities/Subsegment;", "name", "", "openTrace", "Lca/nexapp/tracing/Trace;", "nexapp-tracing"})
public final class XRayTracer
implements Tracer {
    private final AWSXRayRecorder recorder;

    @Override
    @NotNull
    public Trace openTrace(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Subsegment subsegment = this.createSubsegment(name);
        return new XRayTrace((Entity)subsegment);
    }

    private final Subsegment createSubsegment(String name) {
        Subsegment subsegment;
        try {
            subsegment = this.recorder.beginSubsegment(name);
        }
        catch (Exception expected) {
            XRay.INSTANCE.suppressXRayException(expected);
            subsegment = null;
        }
        return subsegment;
    }

    public XRayTracer(@NotNull AWSXRayRecorder recorder) {
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        this.recorder = recorder;
    }

    @Override
    public <T> T trace(@NotNull String name, @NotNull Function1<? super Trace, ? extends T> toTrace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(toTrace, (String)"toTrace");
        return Tracer.DefaultImpls.trace(this, name, toTrace);
    }
}

