/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.tracing;

import ca.nexapp.tracing.MultipleTracers;
import ca.nexapp.tracing.Settings;
import ca.nexapp.tracing.Tracer;
import ca.nexapp.tracing.sentry.SentryTracer;
import ca.nexapp.tracing.sfl4j.Slf4JTracer;
import ca.nexapp.tracing.xray.XRayTracer;
import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import io.sentry.Sentry;
import io.sentry.SentryClient;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lca/nexapp/tracing/TracerFactory;", "", "clock", "Ljava/time/Clock;", "(Ljava/time/Clock;)V", "create", "Lca/nexapp/tracing/Tracer;", "settings", "Lca/nexapp/tracing/Settings;", "createSentryTracer", "Lca/nexapp/tracing/sentry/SentryTracer;", "createXRayTracer", "Lca/nexapp/tracing/xray/XRayTracer;", "nexapp-tracing"})
public final class TracerFactory {
    private final Clock clock;

    @NotNull
    public final Tracer create(@NotNull Settings settings) {
        boolean bl;
        Tracer tracer;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        boolean bl2 = false;
        List tracers = new ArrayList();
        if (settings.getEnableXRay()) {
            Collection collection = tracers;
            tracer = this.createXRayTracer();
            bl = false;
            collection.add(tracer);
        }
        if (settings.getEnableSentry()) {
            Collection collection = tracers;
            tracer = this.createSentryTracer();
            bl = false;
            collection.add(tracer);
        }
        if (settings.getEnableLogging()) {
            Collection collection = tracers;
            tracer = new Slf4JTracer();
            bl = false;
            collection.add(tracer);
        }
        return new MultipleTracers(tracers);
    }

    private final XRayTracer createXRayTracer() {
        AWSXRayRecorder recorder;
        AWSXRayRecorder aWSXRayRecorder = recorder = AWSXRay.getGlobalRecorder();
        Intrinsics.checkNotNullExpressionValue((Object)aWSXRayRecorder, (String)"recorder");
        return new XRayTracer(aWSXRayRecorder);
    }

    private final SentryTracer createSentryTracer() {
        SentryClient client;
        SentryClient sentryClient = client = Sentry.getStoredClient();
        Intrinsics.checkNotNullExpressionValue((Object)sentryClient, (String)"client");
        return new SentryTracer(this.clock, sentryClient);
    }

    public TracerFactory(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
    }
}

