/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.NetworkEx;

public class SceneEx
extends Scene {
    private transient Identifier id;
    private transient MutableLiveData<Boolean> removalObservable;
    private transient MutableLiveData<String> nameObservable;

    protected SceneEx(int sceneId, Network parent) {
        super(sceneId, parent);
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        NetworkEx parent = (NetworkEx)this.getParent();
        if (null != parent) {
            parent.onSceneNameUpdated(this);
        }
        FactoryUtility.postValue(this.nameObservable, name);
    }

    protected void onSceneRemoved() {
        FactoryUtility.postValue(this.removalObservable, true);
    }

    public boolean isRemoved() {
        return !this.getParent().containsScene(this.getId());
    }

    public LiveData<String> getNameObservable() {
        return null != this.nameObservable ? this.nameObservable : (this.nameObservable = FactoryUtility.createLiveData(this.getName()));
    }

    public LiveData<Boolean> getRemovalObservable() {
        return null != this.removalObservable ? this.removalObservable : (this.removalObservable = FactoryUtility.createLiveData(this.isRemoved()));
    }

    public Identifier getIdentifier() {
        return null != this.id ? this.id : (this.id = Identifier.getIdentifier(this));
    }

    private void trimMemory() {
        this.nameObservable = FactoryUtility.nullIfEmpty(this.nameObservable);
        this.removalObservable = FactoryUtility.nullIfEmpty(this.removalObservable);
    }
}

