/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;

@Keep
public class Identifier
extends buzz.getcoco.iot.Identifier
implements Parcelable {
    @Keep
    public static Parcelable.Creator<Identifier> CREATOR = new Parcelable.Creator<Identifier>(){

        public Identifier createFromParcel(Parcel parcel) {
            Identifier identifier;
            Bundle bundle = parcel.readBundle(this.getClass().getClassLoader());
            if (null != bundle) {
                String networkId = bundle.getString("networkId");
                long deviceNodeId = bundle.getLong("device_id");
                String resourceEui = bundle.getString("resourceEui");
                int capabilityId = bundle.getInt("capabilityId");
                int attributeId = bundle.getInt("attributeId");
                int zoneId = bundle.getInt("zoneId");
                int sceneId = bundle.getInt("sceneId");
                int ruleId = bundle.getInt("ruleId");
                identifier = new Identifier(networkId, deviceNodeId, resourceEui, capabilityId, attributeId, zoneId, sceneId, ruleId);
            } else {
                identifier = new Identifier(null);
            }
            return identifier;
        }

        public Identifier[] newArray(int size) {
            return new Identifier[size];
        }
    };

    private Identifier(String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId) {
        super(networkId, deviceNodeId, resourceEui, capabilityId, attributeId, -1, -1, -1);
    }

    private Identifier(String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId, int zoneId, int sceneId, int ruleId) {
        super(networkId, deviceNodeId, resourceEui, capabilityId, attributeId, zoneId, sceneId, ruleId);
    }

    private Identifier(buzz.getcoco.iot.Identifier id) {
        super(id);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        Bundle bundle = new Bundle();
        bundle.putString("networkId", this.networkId);
        bundle.putLong("device_id", this.deviceNodeId);
        bundle.putString("resourceEui", this.resourceEui);
        bundle.putInt("capabilityId", this.capabilityId);
        bundle.putInt("attributeId", this.attributeId);
        bundle.putInt("zoneId", this.zoneId);
        bundle.putInt("sceneId", this.sceneId);
        bundle.putInt("ruleId", this.ruleId);
        parcel.writeBundle(bundle);
    }

    public static Identifier getIdentifier(String networkId) {
        return new Identifier(networkId, -1L, null, -1, -1);
    }

    public static Identifier getIdentifier(Network network) {
        return new Identifier(network.getId(), -1L, null, -1, -1);
    }

    public static Identifier getIdentifier(Device device) {
        return new Identifier(device.getParent().getId(), device.getId(), null, -1, -1);
    }

    public static Identifier getIdentifier(Resource resource) {
        return new Identifier(resource.getParent().getParent().getId(), resource.getParent().getId(), resource.getId(), -1, -1);
    }

    public static Identifier getIdentifier(Capability capability) {
        return new Identifier(capability.getParent().getParent().getParent().getId(), capability.getParent().getParent().getId(), capability.getParent().getId(), capability.getId().getInt(), -1);
    }

    public static Identifier getIdentifier(Attribute attribute) {
        return new Identifier(attribute.getParent().getParent().getParent().getParent().getId(), attribute.getParent().getParent().getParent().getId(), attribute.getParent().getParent().getId(), attribute.getParent().getId().getInt(), attribute.getMapKey());
    }

    public static Identifier getIdentifier(Zone zone) {
        return new Identifier(zone.getParent().getId(), -1L, null, -1, -1, zone.getId(), -1, -1);
    }

    public static Identifier getIdentifier(Scene scene) {
        return new Identifier(scene.getParent().getId(), -1L, null, -1, -1, -1, scene.getId(), -1);
    }

    public static Identifier getIdentifier(Rule rule) {
        return new Identifier(rule.getParent().getId(), -1L, null, -1, -1, -1, -1, rule.getId());
    }

    public static Identifier fromJson(String json) {
        return new Identifier(buzz.getcoco.iot.Identifier.fromJson((String)json));
    }
}

