/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.ResourceCondition;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.ScheduleCondition;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.NetworkEx;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class RuleEx
extends Rule {
    private transient Identifier identifier;
    private transient ImmutableList<Rule.Condition> conditions;
    private transient MutableLiveData<String> nameObservable;
    private transient MutableLiveData<List<Rule.Condition>> conditionsObservable;

    protected RuleEx(int id, Network parent) {
        super(id, parent);
    }

    protected void internalClearAddResourceConditions(Collection<ResourceCondition> resourceConditions) {
        super.internalClearAddResourceConditions(resourceConditions);
        this.recompileAndPostConditions();
    }

    protected void internalClearAddScheduleConditions(Collection<ScheduleCondition> scheduleConditions) {
        super.internalClearAddScheduleConditions(scheduleConditions);
        this.recompileAndPostConditions();
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        NetworkEx parent = (NetworkEx)this.getParent();
        if (null != parent) {
            parent.onRuleNameUpdated(this);
        }
        FactoryUtility.postValue(this.nameObservable, name);
    }

    private void recompileAndPostConditions() {
        if (null == this.conditions) {
            return;
        }
        FactoryUtility.postValue(this.conditionsObservable, this.getConditions());
    }

    public Identifier getIdentifier() {
        return null != this.identifier ? this.identifier : (this.identifier = Identifier.getIdentifier(this));
    }

    public LiveData<String> getNameObservable() {
        return null != this.nameObservable ? this.nameObservable : (this.nameObservable = new MutableLiveData((Object)this.getName()));
    }

    public LiveData<List<Rule.Condition>> getConditionsObservable() {
        return null != this.conditionsObservable ? this.conditionsObservable : (this.conditionsObservable = FactoryUtility.createLiveData(this.getConditions()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Rule.Condition> getConditions() {
        List scheduleConditions;
        ImmutableList.Builder conditionsBuilder = new ImmutableList.Builder();
        List list = scheduleConditions = this.getScheduleConditions();
        synchronized (scheduleConditions) {
            List resourceConditions;
            conditionsBuilder.addAll((Iterable)scheduleConditions);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            list = resourceConditions = this.getResourceConditions();
            synchronized (resourceConditions) {
                conditionsBuilder.addAll((Iterable)resourceConditions);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                this.conditions = conditionsBuilder.build();
                return this.conditions;
            }
        }
    }

    private void trimMemory() {
        this.conditions = null;
        this.nameObservable = FactoryUtility.nullIfEmpty(this.nameObservable);
        this.conditionsObservable = FactoryUtility.nullIfEmpty(this.conditionsObservable);
    }
}

