/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.NetworkEx;
import buzz.getcoco.iot.android.ResourceEx;
import java.util.Iterator;

public class DeviceEx
extends Device {
    private static final String TAG = "DeviceEx";
    private transient Identifier identifier;
    private transient MutableLiveData<Boolean> deviceStateObservable;
    private transient MutableLiveData<String> deviceNameObservable;
    private transient MutableLiveData<Device> deviceRemovalObservable;

    protected DeviceEx(long deviceNodeId, Network parent) {
        super(deviceNodeId, parent);
    }

    protected void internalSetName(String deviceName) {
        super.internalSetName(deviceName);
        NetworkEx parent = (NetworkEx)this.getParent();
        if (null != parent) {
            parent.onDeviceNameUpdated(this);
        }
        Log.d((String)TAG, (String)("internalSetName: " + deviceName));
        FactoryUtility.postValue(this.deviceNameObservable, deviceName);
    }

    protected void internalSetReady(boolean ready) {
        super.internalSetReady(ready);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Resource r = (Resource)iterator.next();
            ResourceEx rex = (ResourceEx)r;
            rex.onStateChange();
        }
        FactoryUtility.postValue(this.deviceStateObservable, ready);
    }

    protected void internalRemoveDevice() {
        super.internalRemoveDevice();
        FactoryUtility.postValue(this.deviceRemovalObservable, this);
    }

    public LiveData<Device> getDeviceRemovalObservable() {
        return null != this.deviceRemovalObservable ? this.deviceRemovalObservable : (this.deviceRemovalObservable = new MutableLiveData());
    }

    public LiveData<Boolean> getDeviceStateObservable() {
        return null != this.deviceStateObservable ? this.deviceStateObservable : (this.deviceStateObservable = FactoryUtility.createLiveData(this.isReady()));
    }

    public LiveData<String> getDeviceNameObservable() {
        return null != this.deviceNameObservable ? this.deviceNameObservable : (this.deviceNameObservable = FactoryUtility.createLiveData(this.getName()));
    }

    public Identifier getIdentifier() {
        return null != this.identifier ? this.identifier : (this.identifier = Identifier.getIdentifier(this));
    }

    private void trimMemory() {
        this.deviceStateObservable = FactoryUtility.nullIfEmpty(this.deviceStateObservable);
        this.deviceNameObservable = FactoryUtility.nullIfEmpty(this.deviceNameObservable);
    }

    @NonNull
    public String toString() {
        return "DeviceEx{id=" + this.getId() + ", name=" + this.getName() + ", psn=" + this.getDevicePsn() + ", productName=" + this.getProductName() + ", ready: " + this.isReady() + '}';
    }
}

