/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.util.Log;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Zone;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.NetworkEx;
import buzz.getcoco.iot.android.ResourceEx;
import java.util.Iterator;
import java.util.Set;

public class ZoneEx
extends Zone {
    private static final String TAG = "ZoneEx";
    private transient Identifier identifier;
    private transient MutableLiveData<String> nameObservable;
    private transient MutableLiveData<Set<Resource>> resourcesObservable;

    protected ZoneEx(int zoneId, Network parent) {
        super(zoneId, parent);
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        NetworkEx parent = (NetworkEx)this.getParent();
        if (null != parent) {
            parent.onZoneNameUpdated(this);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            ((ResourceEx)resource).onZoneNameChanged(name);
        }
        FactoryUtility.postValue(this.nameObservable, name);
    }

    protected void internalRemoveResource(Resource resource) {
        super.internalRemoveResource(resource);
        Log.d((String)TAG, (String)("internalRemoveResource: resourceEui: " + resource.getId() + ", zone name: " + this.getName() + ", device name: " + resource.getParent().getName() + ", network name: " + resource.getParent().getParent().getName()));
        FactoryUtility.postValue(this.resourcesObservable, this.getResources());
    }

    protected void internalAddResource(Resource resource) {
        super.internalAddResource(resource);
        Log.d((String)TAG, (String)("internalAddResource: resource eui: " + resource.getId() + ", zone name: " + this.getName() + ", device name: " + resource.getParent().getName() + ", network name: " + resource.getParent().getParent().getName()));
        FactoryUtility.postValue(this.resourcesObservable, this.getResources());
    }

    public Identifier getIdentifier() {
        return null != this.identifier ? this.identifier : (this.identifier = Identifier.getIdentifier(this));
    }

    public LiveData<String> getNameObservable() {
        return null != this.nameObservable ? this.nameObservable : (this.nameObservable = FactoryUtility.createLiveData(this.getName()));
    }

    public LiveData<Set<Resource>> getResourcesObservable() {
        return null != this.resourcesObservable ? this.resourcesObservable : (this.resourcesObservable = FactoryUtility.createLiveData(this.getResources()));
    }

    private void trimMemory() {
        this.nameObservable = FactoryUtility.nullIfEmpty(this.nameObservable);
        this.resourcesObservable = FactoryUtility.nullIfEmpty(this.resourcesObservable);
    }
}

