package buzz.getcoco.iot.android;

import android.util.Log;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;

import java.util.Set;

import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Zone;

public class ZoneEx extends Zone {

  private static final String TAG = "ZoneEx";

  private transient Identifier identifier;
  private transient MutableLiveData<String> nameObservable;
  private transient MutableLiveData<Set<Resource>> resourcesObservable;

  protected ZoneEx(int zoneId, Network parent) {
    super(zoneId, parent);
  }

  @Override
  protected void internalSetName(String name) {
    NetworkEx parent;
    super.internalSetName(name);

    if (null != (parent = (NetworkEx) getParent())) {
      parent.onZoneNameUpdated(this);
    }

    for (Resource resource : this) {
      ((ResourceEx)resource).onZoneNameChanged(name);
    }

    FactoryUtility.postValue(nameObservable, name);
  }

  @Override
  protected void internalRemoveResource(Resource resource) {
    super.internalRemoveResource(resource);

    Log.d(TAG, "internalRemoveResource: resourceEui: " + resource.getId() + ", zone name: " + this.getName() + ", device name: " + resource.getParent().getName() + ", network name: " + resource.getParent().getParent().getName());
    FactoryUtility.postValue(resourcesObservable, getResources());
  }

  @Override
  protected void internalAddResource(Resource resource) {
    super.internalAddResource(resource);

    Log.d(TAG, "internalAddResource: resource eui: " + resource.getId() + ", zone name: " + this.getName() + ", device name: " + resource.getParent().getName() + ", network name: " + resource.getParent().getParent().getName());
    FactoryUtility.postValue(resourcesObservable, getResources());
  }

  public Identifier getIdentifier() {
    return (null != identifier) ?  identifier : (identifier = Identifier.getIdentifier(this));
  }

  public LiveData<String> getNameObservable() {
    return (null != nameObservable) ? nameObservable : (nameObservable = FactoryUtility.createLiveData(getName()));
  }

  public LiveData<Set<Resource>> getResourcesObservable() {
    return (null != resourcesObservable) ? resourcesObservable : (resourcesObservable = FactoryUtility.createLiveData(getResources()));
  }

  private void trimMemory() {
    nameObservable = FactoryUtility.nullIfEmpty(nameObservable);
    resourcesObservable = FactoryUtility.nullIfEmpty(resourcesObservable);
  }
}
