/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.CustomOverload;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

final class Uri {
    private final String str;
    private int index;
    private boolean pctEncodedFound;

    Uri(String str) {
        this.str = str;
    }

    boolean uri() {
        int start = this.index;
        if (!(this.scheme() && this.take(':') && this.hierPart())) {
            this.index = start;
            return false;
        }
        if (this.take('?') && !this.query()) {
            return false;
        }
        if (this.take('#') && !this.fragment()) {
            return false;
        }
        if (this.index != this.str.length()) {
            this.index = start;
            return false;
        }
        return true;
    }

    private boolean hierPart() {
        int start = this.index;
        if (this.takeDoubleSlash() && this.authority() && this.pathAbempty()) {
            return true;
        }
        this.index = start;
        return this.pathAbsolute() || this.pathRootless() || this.pathEmpty();
    }

    boolean uriReference() {
        return this.uri() || this.relativeRef();
    }

    private boolean relativeRef() {
        int start = this.index;
        if (!this.relativePart()) {
            return false;
        }
        if (this.take('?') && !this.query()) {
            this.index = start;
            return false;
        }
        if (this.take('#') && !this.fragment()) {
            this.index = start;
            return false;
        }
        if (this.index != this.str.length()) {
            this.index = start;
            return false;
        }
        return true;
    }

    private boolean relativePart() {
        int start = this.index;
        if (this.takeDoubleSlash() && this.authority() && this.pathAbempty()) {
            return true;
        }
        this.index = start;
        return this.pathAbsolute() || this.pathNoscheme() || this.pathEmpty();
    }

    private boolean takeDoubleSlash() {
        boolean isSlash = this.take('/');
        return isSlash && this.take('/');
    }

    private boolean scheme() {
        int start = this.index;
        if (this.alpha()) {
            while (this.alpha() || this.digit() || this.take('+') || this.take('-') || this.take('.')) {
            }
            if (this.peek(':')) {
                return true;
            }
        }
        this.index = start;
        return false;
    }

    private boolean authority() {
        int start = this.index;
        if (this.userinfo() && !this.take('@')) {
            this.index = start;
            return false;
        }
        if (!this.host()) {
            this.index = start;
            return false;
        }
        if (this.take(':') && !this.port()) {
            this.index = start;
            return false;
        }
        if (!this.isAuthorityEnd()) {
            this.index = start;
            return false;
        }
        return true;
    }

    private boolean isAuthorityEnd() {
        if (this.index >= this.str.length()) {
            return true;
        }
        char c = this.str.charAt(this.index);
        return c == '?' || c == '#' || c == '/';
    }

    private boolean userinfo() {
        int start = this.index;
        while (this.unreserved() || this.pctEncoded() || this.subDelims() || this.take(':')) {
        }
        if (this.peek('@')) {
            return true;
        }
        this.index = start;
        return false;
    }

    private static int unhex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    private boolean checkHostPctEncoded(String str) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        int strLen = str.length();
        ByteBuffer buffer = ByteBuffer.allocate(strLen);
        CharBuffer out = CharBuffer.allocate(strLen);
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '%') {
                byte b = (byte)((Uri.unhex(str.charAt(i + 1)) & 0xF) << 4 | (Uri.unhex(str.charAt(i + 2)) & 0xF) << 0);
                buffer.put(b);
                i += 3;
                continue;
            }
            buffer.put((byte)(str.charAt(i) & 0xF));
            ++i;
        }
        CoderResult f = decoder.decode((ByteBuffer)buffer.flip(), out, true);
        if (f.isError()) {
            return false;
        }
        f = decoder.flush(out);
        return !f.isError();
    }

    private boolean host() {
        int start = this.index;
        this.pctEncodedFound = false;
        if (this.peek('[') && this.ipLiteral() || this.regName()) {
            if (this.pctEncodedFound) {
                String rawHost = this.str.substring(start, this.index);
                return this.checkHostPctEncoded(rawHost);
            }
            return true;
        }
        return false;
    }

    private boolean port() {
        int start = this.index;
        while (this.digit()) {
        }
        if (this.isAuthorityEnd()) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean ipLiteral() {
        int start = this.index;
        if (this.take('[')) {
            int j = this.index;
            if (this.ipv6Address() && this.take(']')) {
                return true;
            }
            this.index = j;
            if (this.ipv6Addrz() && this.take(']')) {
                return true;
            }
            this.index = j;
            if (this.ipvFuture() && this.take(']')) {
                return true;
            }
        }
        this.index = start;
        return false;
    }

    private boolean ipv6Address() {
        int start = this.index;
        while (this.hexDig() || this.take(':')) {
        }
        if (CustomOverload.isIp(this.str.substring(start, this.index), 6L)) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean ipv6Addrz() {
        int start = this.index;
        if (this.ipv6Address() && this.take('%') && this.take('2') && this.take('5') && this.zoneID()) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean zoneID() {
        int start = this.index;
        while (this.unreserved() || this.pctEncoded()) {
        }
        if (this.index - start > 0) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean ipvFuture() {
        int start = this.index;
        if (this.take('v') && this.hexDig()) {
            while (this.hexDig()) {
            }
            if (this.take('.')) {
                int j = 0;
                while (this.unreserved() || this.subDelims() || this.take(':')) {
                    ++j;
                }
                if (j >= 1) {
                    return true;
                }
            }
        }
        this.index = start;
        return false;
    }

    private boolean regName() {
        int start = this.index;
        while (this.unreserved() || this.pctEncoded() || this.subDelims()) {
        }
        if (this.isAuthorityEnd()) {
            return true;
        }
        if (this.peek(':')) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean isPathEnd() {
        if (this.index >= this.str.length()) {
            return true;
        }
        char c = this.str.charAt(this.index);
        return c == '?' || c == '#';
    }

    private boolean pathAbempty() {
        int start = this.index;
        while (this.take('/') && this.segment()) {
        }
        if (this.isPathEnd()) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean pathAbsolute() {
        int start = this.index;
        if (this.take('/')) {
            if (this.segmentNz()) {
                while (this.take('/') && this.segment()) {
                }
            }
            if (this.isPathEnd()) {
                return true;
            }
        }
        this.index = start;
        return false;
    }

    private boolean pathNoscheme() {
        int start = this.index;
        if (this.segmentNzNc()) {
            while (this.take('/') && this.segment()) {
            }
            if (this.isPathEnd()) {
                return true;
            }
        }
        this.index = start;
        return false;
    }

    private boolean pathRootless() {
        int start = this.index;
        if (this.segmentNz()) {
            while (this.take('/') && this.segment()) {
            }
            if (this.isPathEnd()) {
                return true;
            }
        }
        this.index = start;
        return false;
    }

    private boolean pathEmpty() {
        return this.isPathEnd();
    }

    private boolean segment() {
        while (this.pchar()) {
        }
        return true;
    }

    private boolean segmentNz() {
        int start = this.index;
        if (this.pchar()) {
            while (this.pchar()) {
            }
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean segmentNzNc() {
        int start = this.index;
        while (this.unreserved() || this.pctEncoded() || this.subDelims() || this.take('@')) {
        }
        if (this.index - start > 0) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean pchar() {
        return this.unreserved() || this.pctEncoded() || this.subDelims() || this.take(':') || this.take('@');
    }

    private boolean query() {
        int start = this.index;
        while (this.pchar() || this.take('/') || this.take('?')) {
        }
        if (this.peek('#') || this.index == this.str.length()) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean fragment() {
        int start = this.index;
        while (this.pchar() || this.take('/') || this.take('?')) {
        }
        if (this.index == this.str.length()) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean pctEncoded() {
        int start = this.index;
        if (this.take('%') && this.hexDig() && this.hexDig()) {
            this.pctEncodedFound = true;
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean unreserved() {
        return this.alpha() || this.digit() || this.take('-') || this.take('_') || this.take('.') || this.take('~');
    }

    private boolean subDelims() {
        return this.take('!') || this.take('$') || this.take('&') || this.take('\'') || this.take('(') || this.take(')') || this.take('*') || this.take('+') || this.take(',') || this.take(';') || this.take('=');
    }

    private boolean alpha() {
        if (this.index >= this.str.length()) {
            return false;
        }
        char c = this.str.charAt(this.index);
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean hexDig() {
        if (this.index >= this.str.length()) {
            return false;
        }
        char c = this.str.charAt(this.index);
        if ('0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F') {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean digit() {
        if (this.index >= this.str.length()) {
            return false;
        }
        char c = this.str.charAt(this.index);
        if ('0' <= c && c <= '9') {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean take(char c) {
        if (this.index >= this.str.length()) {
            return false;
        }
        if (this.str.charAt(this.index) == c) {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean peek(char c) {
        return this.index < this.str.length() && this.str.charAt(this.index) == c;
    }
}

