/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import dev.cel.common.values.CelByteString;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

final class ProtoAdapter {
    ProtoAdapter() {
    }

    static Object toCel(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
        Descriptors.FieldDescriptor.Type type = fieldDescriptor.getType();
        if (fieldDescriptor.isMapField()) {
            List<AbstractMessage> input = value instanceof List ? (List<AbstractMessage>)value : Collections.singletonList((AbstractMessage)value);
            Descriptors.FieldDescriptor keyDesc = fieldDescriptor.getMessageType().findFieldByNumber(1);
            Descriptors.FieldDescriptor valDesc = fieldDescriptor.getMessageType().findFieldByNumber(2);
            HashMap<Object, Object> out = new HashMap<Object, Object>(input.size());
            for (AbstractMessage entry : input) {
                Object keyValue = entry.getField(keyDesc);
                Object valValue = entry.getField(valDesc);
                out.put(ProtoAdapter.toCel(keyDesc, keyValue), ProtoAdapter.toCel(valDesc, valValue));
            }
            return out;
        }
        if (fieldDescriptor.isRepeated()) {
            List list = (List)value;
            ArrayList<Object> out = new ArrayList<Object>(list.size());
            for (Object element : list) {
                out.add(ProtoAdapter.scalarToCel(type, element));
            }
            return out;
        }
        return ProtoAdapter.scalarToCel(type, value);
    }

    static Object scalarToCel(Descriptors.FieldDescriptor.Type type, Object value) {
        switch (type) {
            case BYTES: {
                if (value instanceof ByteString) {
                    return CelByteString.of((byte[])((ByteString)value).toByteArray());
                }
                return value;
            }
            case ENUM: {
                if (value instanceof Descriptors.EnumValueDescriptor) {
                    return (long)((Descriptors.EnumValueDescriptor)value).getNumber();
                }
                return value;
            }
            case FLOAT: {
                return (double)((Float)value).floatValue();
            }
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                return (long)((Integer)value).intValue();
            }
            case FIXED32: 
            case UINT32: {
                return UnsignedLong.fromLongBits((long)((Integer)value).intValue());
            }
            case UINT64: 
            case FIXED64: {
                return UnsignedLong.fromLongBits((long)((Long)value));
            }
            case MESSAGE: {
                Message msg = (Message)value;
                if (msg instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)value;
                    return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
                }
                if (msg instanceof Duration) {
                    Duration duration = (Duration)value;
                    return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
                }
                return value;
            }
        }
        return value;
    }
}

