/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.types.TypeType;
import dev.cel.common.values.CelByteString;
import dev.cel.common.values.NullValue;
import dev.cel.runtime.CelEvaluationException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

final class Format {
    Format() {
    }

    static String format(String fmtString, List<?> list) throws CelEvaluationException {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int argIndex = 0;
        block10: while (index < fmtString.length()) {
            char c;
            if ((c = fmtString.charAt(index++)) != '%') {
                builder.append(c);
                if ((c & 0x80) == 0) continue;
                while (index < fmtString.length() && (fmtString.charAt(index) & 0xC0) == 128) {
                    builder.append(fmtString.charAt(index++));
                }
                continue;
            }
            if (index >= fmtString.length()) {
                throw new CelEvaluationException("format: expected format specifier");
            }
            if (fmtString.charAt(index) == '%') {
                builder.append('%');
                ++index;
                continue;
            }
            if (argIndex >= list.size()) {
                throw new CelEvaluationException("index " + argIndex + " out of range");
            }
            Object arg = list.get(argIndex++);
            c = fmtString.charAt(index++);
            int precision = 6;
            if (c == '.') {
                precision = 0;
                while (index < fmtString.length() && '0' <= fmtString.charAt(index) && fmtString.charAt(index) <= '9') {
                    precision = precision * 10 + (fmtString.charAt(index++) - 48);
                }
                if (index >= fmtString.length()) {
                    throw new CelEvaluationException("format: expected format specifier");
                }
                c = fmtString.charAt(index++);
            }
            switch (c) {
                case 'd': {
                    builder.append(Format.formatDecimal(arg));
                    continue block10;
                }
                case 'x': {
                    builder.append(Format.formatHex(arg));
                    continue block10;
                }
                case 'X': {
                    builder.append(Format.formatHex(arg).toUpperCase(Locale.ROOT));
                    continue block10;
                }
                case 's': {
                    builder.append(Format.formatString(arg));
                    continue block10;
                }
                case 'e': {
                    builder.append(Format.formatExponential(arg, precision));
                    continue block10;
                }
                case 'f': {
                    builder.append(Format.formatFloat(arg, precision));
                    continue block10;
                }
                case 'b': {
                    builder.append(Format.formatBinary(arg));
                    continue block10;
                }
                case 'o': {
                    builder.append(Format.formatOctal(arg));
                    continue block10;
                }
            }
            throw new CelEvaluationException("could not parse formatting clause: unrecognized formatting clause \"" + c + "\"");
        }
        return builder.toString();
    }

    private static String formatString(Object val) throws CelEvaluationException {
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof TypeType) {
            return ((TypeType)val).containingTypeName();
        }
        if (val instanceof Boolean) {
            return Boolean.toString((Boolean)val);
        }
        if (val instanceof Long || val instanceof UnsignedLong) {
            Optional<String> str = Format.validateNumber(val);
            return str.orElseGet(val::toString);
        }
        if (val instanceof CelByteString) {
            String byteStr = ((CelByteString)val).toStringUtf8();
            return byteStr.replaceAll("\\ufffd+", "\ufffd");
        }
        if (val instanceof Double) {
            Optional<String> result = Format.validateNumber(val);
            if (result.isPresent()) {
                return result.get();
            }
            return Format.formatDecimal(val);
        }
        if (val instanceof Duration) {
            return Format.formatDuration((Duration)val);
        }
        if (val instanceof java.time.Duration) {
            return Format.formatJavaDuration((java.time.Duration)val);
        }
        if (val instanceof Timestamp) {
            return Format.formatTimestamp((Timestamp)val);
        }
        if (val instanceof Instant) {
            return Format.formatInstant((Instant)val);
        }
        if (val instanceof List) {
            return Format.formatList((List)val);
        }
        if (val instanceof Map) {
            return Format.formatMap((Map)val);
        }
        if (val == null || val instanceof NullValue) {
            return "null";
        }
        throw new CelEvaluationException("error during formatting: string clause can only be used on strings, bools, bytes, ints, doubles, maps, lists, types, durations, and timestamps, was given " + val.getClass());
    }

    private static String formatList(List<?> val) throws CelEvaluationException {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator<?> iter = val.iterator();
        while (iter.hasNext()) {
            Object v = iter.next();
            builder.append(Format.formatString(v));
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(']');
        return builder.toString();
    }

    private static String formatMap(Map<?, ?> val) throws CelEvaluationException {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (Map.Entry<?, ?> entry2 : val.entrySet()) {
            sorted.put(Format.formatString(entry2.getKey()), Format.formatString(entry2.getValue()));
        }
        String result = sorted.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(", "));
        builder.append(result).append('}');
        return builder.toString();
    }

    private static String formatTimestamp(Timestamp timestamp) {
        return DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()));
    }

    private static String formatInstant(Instant instant) {
        return DateTimeFormatter.ISO_INSTANT.format(instant);
    }

    private static String formatDuration(Duration duration) {
        StringBuilder builder = new StringBuilder();
        double totalSeconds = (double)duration.getSeconds() + (double)duration.getNanos() / 1.0E9;
        DecimalFormat formatter = new DecimalFormat("0.#########");
        builder.append(formatter.format(totalSeconds));
        builder.append("s");
        return builder.toString();
    }

    private static String formatJavaDuration(java.time.Duration duration) {
        StringBuilder builder = new StringBuilder();
        double totalSeconds = (double)duration.getSeconds() + (double)duration.getNano() / 1.0E9;
        DecimalFormat formatter = new DecimalFormat("0.#########");
        builder.append(formatter.format(totalSeconds));
        builder.append("s");
        return builder.toString();
    }

    private static String formatHex(Object val) throws CelEvaluationException {
        if (val instanceof Long) {
            return Long.toHexString((Long)val);
        }
        if (val instanceof UnsignedLong) {
            return Long.toHexString(((UnsignedLong)val).longValue());
        }
        if (val instanceof CelByteString) {
            byte[] celBytes;
            StringBuilder hexString = new StringBuilder();
            for (byte b : celBytes = ((CelByteString)val).toByteArray()) {
                hexString.append(String.format("%02x", b));
            }
            return hexString.toString();
        }
        if (val instanceof String) {
            String arg = (String)val;
            return String.format("%x", new BigInteger(1, arg.getBytes(StandardCharsets.UTF_8)));
        }
        throw new CelEvaluationException("error during formatting: only integers, byte buffers, and strings can be formatted as hex, was given " + val.getClass());
    }

    private static String formatDecimal(Object val) throws CelEvaluationException {
        if (val instanceof Long || val instanceof UnsignedLong || val instanceof Double) {
            Optional<String> str = Format.validateNumber(val);
            if (str.isPresent()) {
                return str.get();
            }
            DecimalFormat formatter = new DecimalFormat("0.#########");
            return formatter.format(val);
        }
        throw new CelEvaluationException("error during formatting: decimal clause can only be used on integers, was given " + val.getClass());
    }

    private static String formatOctal(Object val) throws CelEvaluationException {
        if (val instanceof Long) {
            return Long.toOctalString((Long)val);
        }
        if (val instanceof UnsignedLong) {
            return Long.toOctalString(((UnsignedLong)val).longValue());
        }
        throw new CelEvaluationException("error during formatting: octal clause can only be used on integers, was given " + val.getClass());
    }

    private static String formatBinary(Object val) throws CelEvaluationException {
        if (val instanceof Long) {
            return Long.toBinaryString((Long)val);
        }
        if (val instanceof UnsignedLong) {
            return Long.toBinaryString(((UnsignedLong)val).longValue());
        }
        if (val instanceof Boolean) {
            return Boolean.TRUE.equals(val) ? "1" : "0";
        }
        throw new CelEvaluationException("error during formatting: only integers and bools can be formatted as binary, was given " + val.getClass());
    }

    private static String formatExponential(Object val, int precision) throws CelEvaluationException {
        if (val instanceof Double) {
            Optional<String> str = Format.validateNumber(val);
            if (str.isPresent()) {
                return str.get();
            }
            String pattern = "%." + precision + "e";
            return String.format(pattern, val);
        }
        throw new CelEvaluationException("error during formatting: scientific clause can only be used on doubles, was given " + val.getClass());
    }

    private static String formatFloat(Object val, int precision) throws CelEvaluationException {
        if (val instanceof Double) {
            Optional<String> str = Format.validateNumber(val);
            if (str.isPresent()) {
                return str.get();
            }
            StringBuilder pattern = new StringBuilder("0.");
            if (precision > 0) {
                for (int i = 0; i < precision; ++i) {
                    pattern.append("0");
                }
            } else {
                pattern.append("########");
            }
            DecimalFormat formatter = new DecimalFormat(pattern.toString());
            return formatter.format(val);
        }
        throw new CelEvaluationException("error during formatting: fixed-point clause can only be used on doubles, was given " + val.getClass());
    }

    private static Optional<String> validateNumber(Object val) {
        if (val instanceof Double) {
            if ((Double)val == Double.POSITIVE_INFINITY) {
                return Optional.of("Infinity");
            }
            if ((Double)val == Double.NEGATIVE_INFINITY) {
                return Optional.of("-Infinity");
            }
        }
        return Optional.empty();
    }
}

