/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.FieldPathUtils;
import build.buf.protovalidate.ObjectValue;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.RuleViolationHelper;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.ValueEvaluator;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldRules;
import build.buf.validate.Ignore;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;

final class FieldEvaluator
implements Evaluator {
    private static final Descriptors.FieldDescriptor REQUIRED_DESCRIPTOR = FieldRules.getDescriptor().findFieldByNumber(25);
    private static final FieldPath REQUIRED_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(REQUIRED_DESCRIPTOR)).build();
    private final RuleViolationHelper helper;
    final ValueEvaluator valueEvaluator;
    private final Descriptors.FieldDescriptor descriptor;
    private final boolean required;
    private final Ignore ignore;
    private final boolean hasPresence;

    FieldEvaluator(ValueEvaluator valueEvaluator, Descriptors.FieldDescriptor descriptor, boolean required, boolean hasPresence, Ignore ignore) {
        this.helper = new RuleViolationHelper(valueEvaluator);
        this.valueEvaluator = valueEvaluator;
        this.descriptor = descriptor;
        this.required = required;
        this.hasPresence = hasPresence;
        this.ignore = ignore;
    }

    @Override
    public boolean tautology() {
        return !this.required && this.valueEvaluator.tautology();
    }

    private boolean shouldIgnoreAlways() {
        return this.ignore == Ignore.IGNORE_ALWAYS;
    }

    private boolean shouldIgnoreEmpty() {
        return this.hasPresence || this.ignore == Ignore.IGNORE_IF_ZERO_VALUE;
    }

    @Override
    public List<RuleViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        if (this.shouldIgnoreAlways()) {
            return RuleViolation.NO_VIOLATIONS;
        }
        Message message = val.messageValue();
        if (message == null) {
            return RuleViolation.NO_VIOLATIONS;
        }
        boolean hasField = this.descriptor.isRepeated() ? message.getRepeatedFieldCount(this.descriptor) != 0 : message.hasField(this.descriptor);
        if (this.required && !hasField) {
            return Collections.singletonList(RuleViolation.newBuilder().addFirstFieldPathElement(FieldPathUtils.fieldPathElement(this.descriptor)).addAllRulePathElements(this.helper.getRulePrefixElements()).addAllRulePathElements(REQUIRED_RULE_PATH.getElementsList()).setRuleId("required").setMessage("value is required").setRuleValue(new RuleViolation.FieldValue(true, REQUIRED_DESCRIPTOR)));
        }
        if (this.shouldIgnoreEmpty() && !hasField) {
            return RuleViolation.NO_VIOLATIONS;
        }
        return this.valueEvaluator.evaluate(new ObjectValue(this.descriptor, message.getField(this.descriptor)), failFast);
    }
}

