/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.FieldPathUtils;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.RuleViolationHelper;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.ValueEvaluator;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.validate.EnumRules;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldRules;
import com.google.protobuf.Descriptors;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class EnumEvaluator
implements Evaluator {
    private final RuleViolationHelper helper;
    private final Set<Long> values;
    private static final Descriptors.FieldDescriptor DEFINED_ONLY_DESCRIPTOR = EnumRules.getDescriptor().findFieldByNumber(2);
    private static final FieldPath DEFINED_ONLY_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(FieldRules.getDescriptor().findFieldByNumber(16))).addElements(FieldPathUtils.fieldPathElement(DEFINED_ONLY_DESCRIPTOR)).build();

    EnumEvaluator(ValueEvaluator valueEvaluator, List<Descriptors.EnumValueDescriptor> valueDescriptors) {
        this.helper = new RuleViolationHelper(valueEvaluator);
        this.values = valueDescriptors.isEmpty() ? Collections.emptySet() : valueDescriptors.stream().map(it -> it.getNumber()).collect(Collectors.toSet());
    }

    @Override
    public boolean tautology() {
        return false;
    }

    @Override
    public List<RuleViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        Object enumValue = val.value(Object.class);
        if (enumValue == null) {
            return RuleViolation.NO_VIOLATIONS;
        }
        if (!this.values.contains(enumValue)) {
            return Collections.singletonList(RuleViolation.newBuilder().addAllRulePathElements(this.helper.getRulePrefixElements()).addAllRulePathElements(DEFINED_ONLY_RULE_PATH.getElementsList()).addFirstFieldPathElement(this.helper.getFieldPathElement()).setRuleId("enum.defined_only").setMessage("value must be one of the defined enum values").setFieldValue(new RuleViolation.FieldValue(val)).setRuleValue(new RuleViolation.FieldValue(true, DEFINED_ONLY_DESCRIPTOR)));
        }
        return RuleViolation.NO_VIOLATIONS;
    }
}

