/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.CompiledProgram;
import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.FieldPathUtils;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.RuleViolationHelper;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.ValueEvaluator;
import build.buf.protovalidate.Variable;
import build.buf.protovalidate.exceptions.ExecutionException;
import dev.cel.runtime.CelVariableResolver;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class CelPrograms
implements Evaluator {
    private final RuleViolationHelper helper;
    private final List<CompiledProgram> programs;

    CelPrograms(@Nullable ValueEvaluator valueEvaluator, List<CompiledProgram> compiledPrograms) {
        this.helper = new RuleViolationHelper(valueEvaluator);
        this.programs = compiledPrograms;
    }

    @Override
    public boolean tautology() {
        return this.programs.isEmpty();
    }

    @Override
    public List<RuleViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        CelVariableResolver bindings = Variable.newThisVariable(val.value(Object.class));
        ArrayList<RuleViolation.Builder> violations = new ArrayList<RuleViolation.Builder>();
        for (CompiledProgram program : this.programs) {
            RuleViolation.Builder violation = program.eval(val, bindings);
            if (violation == null) continue;
            violations.add(violation);
            if (!failFast) continue;
            break;
        }
        return FieldPathUtils.updatePaths(violations, this.helper.getFieldPathElement(), this.helper.getRulePrefixElements());
    }
}

