/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.ByteString;
import io.envoyproxy.pgv.BytesValidation;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import tests.harness.cases.Oneofs;

public class OneofsValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Oneofs.TestOneOfMsg.class)) {
            return new TestOneOfMsgValidator();
        }
        if (clazz.equals(Oneofs.OneOfNone.class)) {
            return new OneOfNoneValidator();
        }
        if (clazz.equals(Oneofs.OneOf.class)) {
            return new OneOfValidator();
        }
        if (clazz.equals(Oneofs.OneOfRequired.class)) {
            return new OneOfRequiredValidator();
        }
        if (clazz.equals(Oneofs.OneOfIgnoreEmpty.class)) {
            return new OneOfIgnoreEmptyValidator();
        }
        return null;
    }

    public static class TestOneOfMsgValidator
    implements ValidatorImpl<Oneofs.TestOneOfMsg> {
        public void assertValid(Oneofs.TestOneOfMsg proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".tests.harness.cases.TestOneOfMsg.val", (Object)proto.getVal(), (Object)true);
        }
    }

    public static class OneOfNoneValidator
    implements ValidatorImpl<Oneofs.OneOfNone> {
        public void assertValid(Oneofs.OneOfNone proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getOCase()) {
                case X: {
                    break;
                }
            }
        }
    }

    public static class OneOfValidator
    implements ValidatorImpl<Oneofs.OneOf> {
        private final Integer Y__GT = 0;

        public void assertValid(Oneofs.OneOf proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getOCase()) {
                case X: {
                    StringValidation.prefix((String)".tests.harness.cases.OneOf.x", (String)proto.getX(), (String)"foo");
                    break;
                }
                case Y: {
                    ComparativeValidation.greaterThan((String)".tests.harness.cases.OneOf.y", (Object)proto.getY(), (Object)this.Y__GT, Comparator.naturalOrder());
                    break;
                }
                case Z: {
                    if (!proto.hasZ()) break;
                    index.validatorFor((Object)proto.getZ()).assertValid((Object)proto.getZ());
                }
            }
        }
    }

    public static class OneOfRequiredValidator
    implements ValidatorImpl<Oneofs.OneOfRequired> {
        public void assertValid(Oneofs.OneOfRequired proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getOCase()) {
                case X: {
                    break;
                }
                case Y: {
                    break;
                }
                case NAME_WITH_UNDERSCORES: {
                    break;
                }
                case UNDER_AND_1_NUMBER: {
                    break;
                }
                default: {
                    RequiredValidation.required((String)".tests.harness.cases.OneOfRequired.o", null);
                }
            }
        }
    }

    public static class OneOfIgnoreEmptyValidator
    implements ValidatorImpl<Oneofs.OneOfIgnoreEmpty> {
        private final Integer Z__LTE = 128;
        private final Integer Z__GTE = 256;

        public void assertValid(Oneofs.OneOfIgnoreEmpty proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getOCase()) {
                case X: {
                    if (proto.getX().isEmpty()) break;
                    StringValidation.minLength((String)".tests.harness.cases.OneOfIgnoreEmpty.x", (String)proto.getX(), (int)3);
                    StringValidation.maxLength((String)".tests.harness.cases.OneOfIgnoreEmpty.x", (String)proto.getX(), (int)5);
                    break;
                }
                case Y: {
                    if (proto.getY().isEmpty()) break;
                    BytesValidation.minLength((String)".tests.harness.cases.OneOfIgnoreEmpty.y", (ByteString)proto.getY(), (int)3);
                    BytesValidation.maxLength((String)".tests.harness.cases.OneOfIgnoreEmpty.y", (ByteString)proto.getY(), (int)5);
                    break;
                }
                case Z: {
                    if (proto.getZ() == 0) break;
                    ComparativeValidation.range((String)".tests.harness.cases.OneOfIgnoreEmpty.z", (Object)proto.getZ(), null, (Object)this.Z__LTE, null, (Object)this.Z__GTE, Comparator.naturalOrder());
                }
            }
        }
    }
}

