/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.Message;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import tests.harness.cases.Messages;

public class MessagesValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Messages.TestMsg.class)) {
            return new TestMsgValidator();
        }
        if (clazz.equals(Messages.MessageNone.class)) {
            return new MessageNoneValidator();
        }
        if (clazz.equals(Messages.MessageDisabled.class)) {
            return new MessageDisabledValidator();
        }
        if (clazz.equals(Messages.Message.class)) {
            return new MessageValidator();
        }
        if (clazz.equals(Messages.MessageCrossPackage.class)) {
            return new MessageCrossPackageValidator();
        }
        if (clazz.equals(Messages.MessageSkip.class)) {
            return new MessageSkipValidator();
        }
        if (clazz.equals(Messages.MessageRequired.class)) {
            return new MessageRequiredValidator();
        }
        if (clazz.equals(Messages.MessageRequiredButOptional.class)) {
            return new MessageRequiredButOptionalValidator();
        }
        if (clazz.equals(Messages.MessageRequiredOneof.class)) {
            return new MessageRequiredOneofValidator();
        }
        if (clazz.equals(Messages.MessageWith3dInside.class)) {
            return new MessageWith3DInsideValidator();
        }
        if (clazz.equals(Messages.MessageNone.NoneMsg.class)) {
            return new MessageNone_NoneMsgValidator();
        }
        return null;
    }

    public static class TestMsgValidator
    implements ValidatorImpl<Messages.TestMsg> {
        public void assertValid(Messages.TestMsg proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".tests.harness.cases.TestMsg.const", (Object)proto.getConst(), (Object)"foo");
            if (proto.hasNested()) {
                index.validatorFor((Object)proto.getNested()).assertValid((Object)proto.getNested());
            }
        }
    }

    public static class MessageNoneValidator
    implements ValidatorImpl<Messages.MessageNone> {
        public void assertValid(Messages.MessageNone proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }

    public static class MessageDisabledValidator
    implements ValidatorImpl<Messages.MessageDisabled> {
        private final Long VAL__GT = 123L;

        public void assertValid(Messages.MessageDisabled proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class MessageValidator
    implements ValidatorImpl<Messages.Message> {
        public void assertValid(Messages.Message proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }

    public static class MessageCrossPackageValidator
    implements ValidatorImpl<Messages.MessageCrossPackage> {
        public void assertValid(Messages.MessageCrossPackage proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }

    public static class MessageSkipValidator
    implements ValidatorImpl<Messages.MessageSkip> {
        public void assertValid(Messages.MessageSkip proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class MessageRequiredValidator
    implements ValidatorImpl<Messages.MessageRequired> {
        public void assertValid(Messages.MessageRequired proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                RequiredValidation.required((String)".tests.harness.cases.MessageRequired.val", (Message)proto.getVal());
            } else {
                RequiredValidation.required((String)".tests.harness.cases.MessageRequired.val", null);
            }
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }

    public static class MessageRequiredButOptionalValidator
    implements ValidatorImpl<Messages.MessageRequiredButOptional> {
        public void assertValid(Messages.MessageRequiredButOptional proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                if (proto.hasVal()) {
                    RequiredValidation.required((String)".tests.harness.cases.MessageRequiredButOptional.val", (Message)proto.getVal());
                } else {
                    RequiredValidation.required((String)".tests.harness.cases.MessageRequiredButOptional.val", null);
                }
                if (proto.hasVal()) {
                    index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
                }
            }
        }
    }

    public static class MessageRequiredOneofValidator
    implements ValidatorImpl<Messages.MessageRequiredOneof> {
        public void assertValid(Messages.MessageRequiredOneof proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getOneCase()) {
                case VAL: {
                    if (proto.hasVal()) {
                        RequiredValidation.required((String)".tests.harness.cases.MessageRequiredOneof.val", (Message)proto.getVal());
                    } else {
                        RequiredValidation.required((String)".tests.harness.cases.MessageRequiredOneof.val", null);
                    }
                    if (!proto.hasVal()) break;
                    index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
                    break;
                }
                default: {
                    RequiredValidation.required((String)".tests.harness.cases.MessageRequiredOneof.one", null);
                }
            }
        }
    }

    public static class MessageWith3DInsideValidator
    implements ValidatorImpl<Messages.MessageWith3dInside> {
        public void assertValid(Messages.MessageWith3dInside proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class MessageNone_NoneMsgValidator
    implements ValidatorImpl<Messages.MessageNone.NoneMsg> {
        public void assertValid(Messages.MessageNone.NoneMsg proto, ValidatorIndex index) throws ValidationException {
        }
    }
}

