/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.re2j.Pattern;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.MapValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import tests.harness.cases.Maps;

public class MapsValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Maps.MapNone.class)) {
            return new MapNoneValidator();
        }
        if (clazz.equals(Maps.MapMin.class)) {
            return new MapMinValidator();
        }
        if (clazz.equals(Maps.MapMax.class)) {
            return new MapMaxValidator();
        }
        if (clazz.equals(Maps.MapMinMax.class)) {
            return new MapMinMaxValidator();
        }
        if (clazz.equals(Maps.MapExact.class)) {
            return new MapExactValidator();
        }
        if (clazz.equals(Maps.MapNoSparse.class)) {
            return new MapNoSparseValidator();
        }
        if (clazz.equals(Maps.MapKeys.class)) {
            return new MapKeysValidator();
        }
        if (clazz.equals(Maps.MapValues.class)) {
            return new MapValuesValidator();
        }
        if (clazz.equals(Maps.MapKeysPattern.class)) {
            return new MapKeysPatternValidator();
        }
        if (clazz.equals(Maps.MapValuesPattern.class)) {
            return new MapValuesPatternValidator();
        }
        if (clazz.equals(Maps.MapRecursive.class)) {
            return new MapRecursiveValidator();
        }
        if (clazz.equals(Maps.MapExactIgnore.class)) {
            return new MapExactIgnoreValidator();
        }
        if (clazz.equals(Maps.MultipleMaps.class)) {
            return new MultipleMapsValidator();
        }
        if (clazz.equals(Maps.MapKeysIn.class)) {
            return new MapKeysInValidator();
        }
        if (clazz.equals(Maps.MapKeysNotIn.class)) {
            return new MapKeysNotInValidator();
        }
        if (clazz.equals(Maps.MapNoSparse.Msg.class)) {
            return new MapNoSparse_MsgValidator();
        }
        if (clazz.equals(Maps.MapRecursive.Msg.class)) {
            return new MapRecursive_MsgValidator();
        }
        return null;
    }

    public static class MapNoneValidator
    implements ValidatorImpl<Maps.MapNone> {
        public void assertValid(Maps.MapNone proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class MapMinValidator
    implements ValidatorImpl<Maps.MapMin> {
        public void assertValid(Maps.MapMin proto, ValidatorIndex index) throws ValidationException {
            MapValidation.min((String)".tests.harness.cases.MapMin.val", proto.getValMap(), (int)2);
        }
    }

    public static class MapMaxValidator
    implements ValidatorImpl<Maps.MapMax> {
        public void assertValid(Maps.MapMax proto, ValidatorIndex index) throws ValidationException {
            MapValidation.max((String)".tests.harness.cases.MapMax.val", proto.getValMap(), (int)3);
        }
    }

    public static class MapMinMaxValidator
    implements ValidatorImpl<Maps.MapMinMax> {
        public void assertValid(Maps.MapMinMax proto, ValidatorIndex index) throws ValidationException {
            MapValidation.min((String)".tests.harness.cases.MapMinMax.val", proto.getValMap(), (int)2);
            MapValidation.max((String)".tests.harness.cases.MapMinMax.val", proto.getValMap(), (int)4);
        }
    }

    public static class MapExactValidator
    implements ValidatorImpl<Maps.MapExact> {
        public void assertValid(Maps.MapExact proto, ValidatorIndex index) throws ValidationException {
            MapValidation.min((String)".tests.harness.cases.MapExact.val", proto.getValMap(), (int)3);
            MapValidation.max((String)".tests.harness.cases.MapExact.val", proto.getValMap(), (int)3);
        }
    }

    public static class MapNoSparseValidator
    implements ValidatorImpl<Maps.MapNoSparse> {
        public void assertValid(Maps.MapNoSparse proto, ValidatorIndex index) throws ValidationException {
            MapValidation.noSparse((String)".tests.harness.cases.MapNoSparse.val", proto.getValMap());
            MapValidation.validateParts(proto.getValMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getValMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class MapKeysValidator
    implements ValidatorImpl<Maps.MapKeys> {
        private final Long VAL_KEY_LT = 0L;

        public void assertValid(Maps.MapKeys proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> ComparativeValidation.lessThan((String)".tests.harness.cases.MapKeys.val", (Object)key, (Object)this.VAL_KEY_LT, Comparator.naturalOrder()));
            MapValidation.validateParts(proto.getValMap().values(), value -> {});
        }
    }

    public static class MapValuesValidator
    implements ValidatorImpl<Maps.MapValues> {
        public void assertValid(Maps.MapValues proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getValMap().values(), value -> StringValidation.minLength((String)".tests.harness.cases.MapValues.val", (String)value, (int)3));
        }
    }

    public static class MapKeysPatternValidator
    implements ValidatorImpl<Maps.MapKeysPattern> {
        Pattern VAL_KEY_PATTERN = Pattern.compile((String)"(?i)^[a-z0-9]+$");

        public void assertValid(Maps.MapKeysPattern proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> StringValidation.pattern((String)".tests.harness.cases.MapKeysPattern.val", (String)key, (Pattern)this.VAL_KEY_PATTERN));
            MapValidation.validateParts(proto.getValMap().values(), value -> {});
        }
    }

    public static class MapValuesPatternValidator
    implements ValidatorImpl<Maps.MapValuesPattern> {
        Pattern VAL_VALUE_PATTERN = Pattern.compile((String)"(?i)^[a-z0-9]+$");

        public void assertValid(Maps.MapValuesPattern proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getValMap().values(), value -> StringValidation.pattern((String)".tests.harness.cases.MapValuesPattern.val", (String)value, (Pattern)this.VAL_VALUE_PATTERN));
        }
    }

    public static class MapRecursiveValidator
    implements ValidatorImpl<Maps.MapRecursive> {
        public void assertValid(Maps.MapRecursive proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getValMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class MapExactIgnoreValidator
    implements ValidatorImpl<Maps.MapExactIgnore> {
        public void assertValid(Maps.MapExactIgnore proto, ValidatorIndex index) throws ValidationException {
            if (!proto.getValMap().isEmpty()) {
                MapValidation.min((String)".tests.harness.cases.MapExactIgnore.val", proto.getValMap(), (int)3);
                MapValidation.max((String)".tests.harness.cases.MapExactIgnore.val", proto.getValMap(), (int)3);
            }
        }
    }

    public static class MultipleMapsValidator
    implements ValidatorImpl<Maps.MultipleMaps> {
        private final Integer FIRST_KEY_GT = 0;
        private final Integer SECOND_KEY_LT = 0;
        private final Integer THIRD_KEY_GT = 0;

        public void assertValid(Maps.MultipleMaps proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getFirstMap().keySet(), key -> ComparativeValidation.greaterThan((String)".tests.harness.cases.MultipleMaps.first", (Object)key, (Object)this.FIRST_KEY_GT, Comparator.naturalOrder()));
            MapValidation.validateParts(proto.getFirstMap().values(), value -> {});
            MapValidation.validateParts(proto.getSecondMap().keySet(), key -> ComparativeValidation.lessThan((String)".tests.harness.cases.MultipleMaps.second", (Object)key, (Object)this.SECOND_KEY_LT, Comparator.naturalOrder()));
            MapValidation.validateParts(proto.getSecondMap().values(), value -> {});
            MapValidation.validateParts(proto.getThirdMap().keySet(), key -> ComparativeValidation.greaterThan((String)".tests.harness.cases.MultipleMaps.third", (Object)key, (Object)this.THIRD_KEY_GT, Comparator.naturalOrder()));
            MapValidation.validateParts(proto.getThirdMap().values(), value -> {});
        }
    }

    public static class MapKeysInValidator
    implements ValidatorImpl<Maps.MapKeysIn> {
        private final String[] VAL_KEY_IN = new String[]{"foo", "bar"};

        public void assertValid(Maps.MapKeysIn proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> CollectiveValidation.in((String)".tests.harness.cases.MapKeysIn.val", (Object)key, (Object[])this.VAL_KEY_IN));
            MapValidation.validateParts(proto.getValMap().values(), value -> {});
        }
    }

    public static class MapKeysNotInValidator
    implements ValidatorImpl<Maps.MapKeysNotIn> {
        private final String[] VAL_KEY_NOT_IN = new String[]{"foo", "bar"};

        public void assertValid(Maps.MapKeysNotIn proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> CollectiveValidation.notIn((String)".tests.harness.cases.MapKeysNotIn.val", (Object)key, (Object[])this.VAL_KEY_NOT_IN));
            MapValidation.validateParts(proto.getValMap().values(), value -> {});
        }
    }

    public static class MapNoSparse_MsgValidator
    implements ValidatorImpl<Maps.MapNoSparse.Msg> {
        public void assertValid(Maps.MapNoSparse.Msg proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class MapRecursive_MsgValidator
    implements ValidatorImpl<Maps.MapRecursive.Msg> {
        public void assertValid(Maps.MapRecursive.Msg proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".tests.harness.cases.MapRecursive.Msg.val", (String)proto.getVal(), (int)3);
        }
    }
}

