/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.ByteString;
import com.google.re2j.Pattern;
import io.envoyproxy.pgv.BytesValidation;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import tests.harness.cases.Bytes;

public class BytesValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Bytes.BytesNone.class)) {
            return new BytesNoneValidator();
        }
        if (clazz.equals(Bytes.BytesConst.class)) {
            return new BytesConstValidator();
        }
        if (clazz.equals(Bytes.BytesIn.class)) {
            return new BytesInValidator();
        }
        if (clazz.equals(Bytes.BytesNotIn.class)) {
            return new BytesNotInValidator();
        }
        if (clazz.equals(Bytes.BytesLen.class)) {
            return new BytesLenValidator();
        }
        if (clazz.equals(Bytes.BytesMinLen.class)) {
            return new BytesMinLenValidator();
        }
        if (clazz.equals(Bytes.BytesMaxLen.class)) {
            return new BytesMaxLenValidator();
        }
        if (clazz.equals(Bytes.BytesMinMaxLen.class)) {
            return new BytesMinMaxLenValidator();
        }
        if (clazz.equals(Bytes.BytesEqualMinMaxLen.class)) {
            return new BytesEqualMinMaxLenValidator();
        }
        if (clazz.equals(Bytes.BytesPattern.class)) {
            return new BytesPatternValidator();
        }
        if (clazz.equals(Bytes.BytesPrefix.class)) {
            return new BytesPrefixValidator();
        }
        if (clazz.equals(Bytes.BytesContains.class)) {
            return new BytesContainsValidator();
        }
        if (clazz.equals(Bytes.BytesSuffix.class)) {
            return new BytesSuffixValidator();
        }
        if (clazz.equals(Bytes.BytesIP.class)) {
            return new BytesIPValidator();
        }
        if (clazz.equals(Bytes.BytesIPv4.class)) {
            return new BytesIPv4Validator();
        }
        if (clazz.equals(Bytes.BytesIPv6.class)) {
            return new BytesIPv6Validator();
        }
        if (clazz.equals(Bytes.BytesIPv6Ignore.class)) {
            return new BytesIPv6IgnoreValidator();
        }
        return null;
    }

    public static class BytesNoneValidator
    implements ValidatorImpl<Bytes.BytesNone> {
        public void assertValid(Bytes.BytesNone proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class BytesConstValidator
    implements ValidatorImpl<Bytes.BytesConst> {
        private final ByteString VAL__CONST = ByteString.copyFrom((byte[])new byte[]{102, 111, 111});

        public void assertValid(Bytes.BytesConst proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".tests.harness.cases.BytesConst.val", (Object)proto.getVal(), (Object)this.VAL__CONST);
        }
    }

    public static class BytesInValidator
    implements ValidatorImpl<Bytes.BytesIn> {
        private final ByteString[] VAL__IN = new ByteString[]{ByteString.copyFrom((byte[])new byte[]{98, 97, 114}), ByteString.copyFrom((byte[])new byte[]{98, 97, 122})};

        public void assertValid(Bytes.BytesIn proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.in((String)".tests.harness.cases.BytesIn.val", (Object)proto.getVal(), (Object[])this.VAL__IN);
        }
    }

    public static class BytesNotInValidator
    implements ValidatorImpl<Bytes.BytesNotIn> {
        private final ByteString[] VAL__NOT_IN = new ByteString[]{ByteString.copyFrom((byte[])new byte[]{102, 105, 122, 122}), ByteString.copyFrom((byte[])new byte[]{98, 117, 122, 122})};

        public void assertValid(Bytes.BytesNotIn proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.notIn((String)".tests.harness.cases.BytesNotIn.val", (Object)proto.getVal(), (Object[])this.VAL__NOT_IN);
        }
    }

    public static class BytesLenValidator
    implements ValidatorImpl<Bytes.BytesLen> {
        public void assertValid(Bytes.BytesLen proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.length((String)".tests.harness.cases.BytesLen.val", (ByteString)proto.getVal(), (int)3);
        }
    }

    public static class BytesMinLenValidator
    implements ValidatorImpl<Bytes.BytesMinLen> {
        public void assertValid(Bytes.BytesMinLen proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.minLength((String)".tests.harness.cases.BytesMinLen.val", (ByteString)proto.getVal(), (int)3);
        }
    }

    public static class BytesMaxLenValidator
    implements ValidatorImpl<Bytes.BytesMaxLen> {
        public void assertValid(Bytes.BytesMaxLen proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.maxLength((String)".tests.harness.cases.BytesMaxLen.val", (ByteString)proto.getVal(), (int)5);
        }
    }

    public static class BytesMinMaxLenValidator
    implements ValidatorImpl<Bytes.BytesMinMaxLen> {
        public void assertValid(Bytes.BytesMinMaxLen proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.minLength((String)".tests.harness.cases.BytesMinMaxLen.val", (ByteString)proto.getVal(), (int)3);
            BytesValidation.maxLength((String)".tests.harness.cases.BytesMinMaxLen.val", (ByteString)proto.getVal(), (int)5);
        }
    }

    public static class BytesEqualMinMaxLenValidator
    implements ValidatorImpl<Bytes.BytesEqualMinMaxLen> {
        public void assertValid(Bytes.BytesEqualMinMaxLen proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.minLength((String)".tests.harness.cases.BytesEqualMinMaxLen.val", (ByteString)proto.getVal(), (int)5);
            BytesValidation.maxLength((String)".tests.harness.cases.BytesEqualMinMaxLen.val", (ByteString)proto.getVal(), (int)5);
        }
    }

    public static class BytesPatternValidator
    implements ValidatorImpl<Bytes.BytesPattern> {
        private final Pattern VAL__PATTERN = Pattern.compile((String)"^[\\x00-\\x7f]+$");

        public void assertValid(Bytes.BytesPattern proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.pattern((String)".tests.harness.cases.BytesPattern.val", (ByteString)proto.getVal(), (Pattern)this.VAL__PATTERN);
        }
    }

    public static class BytesPrefixValidator
    implements ValidatorImpl<Bytes.BytesPrefix> {
        private final byte[] VAL__PREFIX = new byte[]{-103};

        public void assertValid(Bytes.BytesPrefix proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.prefix((String)".tests.harness.cases.BytesPrefix.val", (ByteString)proto.getVal(), (byte[])this.VAL__PREFIX);
        }
    }

    public static class BytesContainsValidator
    implements ValidatorImpl<Bytes.BytesContains> {
        private final byte[] VAL__CONTAINS = new byte[]{98, 97, 114};

        public void assertValid(Bytes.BytesContains proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.contains((String)".tests.harness.cases.BytesContains.val", (ByteString)proto.getVal(), (byte[])this.VAL__CONTAINS);
        }
    }

    public static class BytesSuffixValidator
    implements ValidatorImpl<Bytes.BytesSuffix> {
        private final byte[] VAL__SUFFIX = new byte[]{98, 117, 122, 122};

        public void assertValid(Bytes.BytesSuffix proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.suffix((String)".tests.harness.cases.BytesSuffix.val", (ByteString)proto.getVal(), (byte[])this.VAL__SUFFIX);
        }
    }

    public static class BytesIPValidator
    implements ValidatorImpl<Bytes.BytesIP> {
        public void assertValid(Bytes.BytesIP proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.ip((String)".tests.harness.cases.BytesIP.val", (ByteString)proto.getVal());
        }
    }

    public static class BytesIPv4Validator
    implements ValidatorImpl<Bytes.BytesIPv4> {
        public void assertValid(Bytes.BytesIPv4 proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.ipv4((String)".tests.harness.cases.BytesIPv4.val", (ByteString)proto.getVal());
        }
    }

    public static class BytesIPv6Validator
    implements ValidatorImpl<Bytes.BytesIPv6> {
        public void assertValid(Bytes.BytesIPv6 proto, ValidatorIndex index) throws ValidationException {
            BytesValidation.ipv6((String)".tests.harness.cases.BytesIPv6.val", (ByteString)proto.getVal());
        }
    }

    public static class BytesIPv6IgnoreValidator
    implements ValidatorImpl<Bytes.BytesIPv6Ignore> {
        public void assertValid(Bytes.BytesIPv6Ignore proto, ValidatorIndex index) throws ValidationException {
            if (!proto.getVal().isEmpty()) {
                BytesValidation.ipv6((String)".tests.harness.cases.BytesIPv6Ignore.val", (ByteString)proto.getVal());
            }
        }
    }
}

