/*
 * Decompiled with CFR 0.152.
 */
package br.com.tempest.sentinelapi;

import br.com.tempest.sentinelapi.DomainException;
import br.com.tempest.sentinelapi.ErrorCollection;
import br.com.tempest.sentinelapi.InfraException;
import br.com.tempest.sentinelapi.ResourceNotFoundException;
import br.com.tempest.sentinelapi.UnauthorizedRequestException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;

public class HttpService {
    private String key;
    private String secret;
    private String host = "https://api.sentinelapp.com.br";
    private WebResource service;

    public HttpService(String key, String secret) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        Client client = Client.create((ClientConfig)config);
        this.service = client.resource(this.host);
        this.service.addFilter((ClientFilter)new HTTPBasicAuthFilter(key, secret));
    }

    public HttpService(String key, String secret, String host) {
        this(key, secret);
        this.host = host;
    }

    public String get(String path) {
        return this.getContent((ClientResponse)this.service.path(path).type("application/json").get(ClientResponse.class));
    }

    public String post(String path, Object body) {
        return this.getContent((ClientResponse)this.service.path(path).type("application/json").post(ClientResponse.class, body));
    }

    public String put(String path, Object body) {
        return this.getContent((ClientResponse)this.service.path(path).type("application/json").put(ClientResponse.class, body));
    }

    public String delete(String path) {
        return this.getContent((ClientResponse)this.service.path(path).type("application/json").delete(ClientResponse.class));
    }

    private String getContent(ClientResponse response) {
        if (ClientResponse.Status.OK.getStatusCode() == response.getStatus()) {
            return (String)response.getEntity(String.class);
        }
        if (response.getStatus() == 401) {
            throw new UnauthorizedRequestException();
        }
        if (response.getStatus() == 404) {
            throw new ResourceNotFoundException();
        }
        if (response.getStatus() == 422) {
            ErrorCollection errors = (ErrorCollection)response.getEntity(ErrorCollection.class);
            throw new DomainException(errors.getErrors());
        }
        throw new InfraException("HTTP error: " + response.getStatus());
    }
}

