/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.zaproxy.clientapi.core;

public class Alert {
    private String alert;
    private Risk risk;
    @Deprecated
    private Reliability reliability;
    private Confidence confidence;
    private String url;
    private String other;
    private String param;
    private String attack;
    private String evidence;
    private String description;
    private String reference;
    private String solution;
    private int cweId;
    private int wascId;

    public Alert(String alert, String url, String riskStr, String confidenceStr, String param, String other) {
        this.alert = alert;
        this.url = url;
        this.other = other;
        this.param = param;
        if (riskStr != null) {
            this.risk = Risk.valueOf(riskStr);
        }
        if (confidenceStr != null) {
            this.confidence = Confidence.valueOf(confidenceStr);
        }
    }

    public Alert(String alert, String url, Risk risk, Confidence confidence, String param, String other, String attack, String description, String reference, String solution, String evidence, int cweId, int wascId) {
        this.alert = alert;
        this.risk = risk;
        this.confidence = confidence;
        this.url = url;
        this.other = other;
        this.param = param;
        this.attack = attack;
        this.description = description;
        this.reference = reference;
        this.solution = solution;
        this.evidence = evidence;
        this.cweId = cweId;
        this.wascId = wascId;
    }

    public Alert(String alert, String url, Risk risk, Confidence confidence, String param, String other) {
        this.alert = alert;
        this.risk = risk;
        this.confidence = confidence;
        this.url = url;
        this.other = other;
        this.param = param;
    }

    public Alert(String alert, String url, Risk risk, Confidence confidence) {
        this.alert = alert;
        this.risk = risk;
        this.confidence = confidence;
        this.url = url;
    }

    public Alert(String alert, String url) {
        this.alert = alert;
        this.url = url;
    }

    public String getAlert() {
        return this.alert;
    }

    public void setAlert(String alert) {
        this.alert = alert;
    }

    public Risk getRisk() {
        return this.risk;
    }

    public void setRisk(Risk risk) {
        this.risk = risk;
    }

    public void setRisk(String risk) {
        this.risk = Risk.valueOf(risk);
    }

    @Deprecated
    public Reliability getReliability() {
        return this.reliability;
    }

    @Deprecated
    public void setReliability(Reliability reliability) {
        this.reliability = reliability;
    }

    @Deprecated
    public void setReliability(String reliability) {
        this.reliability = Reliability.valueOf(reliability);
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public void setConfidence(String confidence) {
        this.confidence = Confidence.valueOf(confidence);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getAttack() {
        return this.attack;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public int getCweId() {
        return this.cweId;
    }

    public int getWascId() {
        return this.wascId;
    }

    public boolean matches(Alert alertFilter) {
        boolean matches = true;
        if (alertFilter.getAlert() != null && !alertFilter.getAlert().equals(this.alert)) {
            matches = false;
        }
        if (alertFilter.getRisk() != null && !alertFilter.getRisk().equals((Object)this.risk)) {
            matches = false;
        }
        if (alertFilter.getConfidence() != null && !alertFilter.getConfidence().equals((Object)this.confidence)) {
            matches = false;
        }
        return matches;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alert == null ? 0 : this.alert.hashCode());
        result = 31 * result + (this.attack == null ? 0 : this.attack.hashCode());
        result = 31 * result + this.cweId;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.evidence == null ? 0 : this.evidence.hashCode());
        result = 31 * result + (this.other == null ? 0 : this.other.hashCode());
        result = 31 * result + (this.param == null ? 0 : this.param.hashCode());
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        result = 31 * result + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = 31 * result + (this.risk == null ? 0 : this.risk.hashCode());
        result = 31 * result + (this.solution == null ? 0 : this.solution.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + this.wascId;
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Alert otherAlert = (Alert)object;
        if (this.alert == null ? otherAlert.alert != null : !this.alert.equals(otherAlert.alert)) {
            return false;
        }
        if (this.attack == null ? otherAlert.attack != null : !this.attack.equals(otherAlert.attack)) {
            return false;
        }
        if (this.cweId != otherAlert.cweId) {
            return false;
        }
        if (this.description == null ? otherAlert.description != null : !this.description.equals(otherAlert.description)) {
            return false;
        }
        if (this.evidence == null ? otherAlert.evidence != null : !this.evidence.equals(otherAlert.evidence)) {
            return false;
        }
        if (this.other == null ? otherAlert.other != null : !this.other.equals(otherAlert.other)) {
            return false;
        }
        if (this.param == null ? otherAlert.param != null : !this.param.equals(otherAlert.param)) {
            return false;
        }
        if (this.reference == null ? otherAlert.reference != null : !this.reference.equals(otherAlert.reference)) {
            return false;
        }
        if (this.confidence != otherAlert.confidence) {
            return false;
        }
        if (this.risk != otherAlert.risk) {
            return false;
        }
        if (this.solution == null ? otherAlert.solution != null : !this.solution.equals(otherAlert.solution)) {
            return false;
        }
        if (this.url == null ? otherAlert.url != null : !this.url.equals(otherAlert.url)) {
            return false;
        }
        return this.wascId == otherAlert.wascId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tAlert: ").append(this.getAlert()).append(", ");
        sb.append("Risk: ");
        if (this.getRisk() != null) {
            sb.append(this.getRisk().name());
        } else {
            sb.append("null");
        }
        sb.append(", ");
        sb.append("Confidence: ");
        if (this.getConfidence() != null) {
            sb.append(this.getConfidence().name());
        } else {
            sb.append("null");
        }
        sb.append(", ");
        sb.append("Url: ").append(this.getUrl()).append(", ");
        sb.append("Param: ").append(this.getParam()).append(", ");
        sb.append("Other: ").append(this.getOther());
        return sb.toString();
    }

    public static enum Confidence {
        Low,
        Medium,
        High,
        Confirmed;

    }

    @Deprecated
    public static enum Reliability {
        Suspicious,
        Warning;

    }

    public static enum Risk {
        Informational,
        Low,
        Medium,
        High;

    }
}

