/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.authentication;

import br.com.softplan.security.zap.api.authentication.AbstractAuthenticationHandler;
import br.com.softplan.security.zap.api.authentication.WebDriverFactory;
import br.com.softplan.security.zap.api.model.AuthenticationInfo;
import br.com.softplan.security.zap.commons.ZapInfo;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ClientApi;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeleniumAuthenticationHandler.class);

    protected SeleniumAuthenticationHandler(ClientApi api, ZapInfo zapInfo, AuthenticationInfo authenticationInfo) {
        super(api, zapInfo, authenticationInfo);
    }

    @Override
    protected void setupAuthentication(String targetUrl) {
        this.addHttpSessionTokens(targetUrl);
        this.triggerAuthenticationViaWebDriver();
        this.setHttpSessionAsActive(targetUrl);
    }

    private void triggerAuthenticationViaWebDriver() {
        AuthenticationInfo authenticationInfo = this.getAuthenticationInfo();
        LOGGER.info("--- Performing authentication via Selenium ({}) ---", (Object)authenticationInfo.getSeleniumDriver());
        WebDriver driver = WebDriverFactory.makeWebDriver(this.getZapInfo(), authenticationInfo);
        driver.get(authenticationInfo.getLoginUrl());
        WebElement usernameField = driver.findElement(By.id((String)authenticationInfo.getUsernameParameter()));
        usernameField.sendKeys(new CharSequence[]{authenticationInfo.getUsername()});
        WebElement passwordField = driver.findElement(By.id((String)authenticationInfo.getPasswordParameter()));
        passwordField.sendKeys(new CharSequence[]{authenticationInfo.getPassword()});
        passwordField.submit();
        driver.quit();
        LOGGER.info("--- Finished performing authentication via Selenium ---\n");
    }
}

