/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.Adler32;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;

public class LogEntryHeader {
    static final int MIN_HEADER_SIZE = 14;
    static final int MAX_HEADER_SIZE = 30;
    private static final int CHECKSUM_BYTES = 4;
    private static final int ENTRYTYPE_OFFSET = 4;
    private static final int PREV_OFFSET = 6;
    private static final int ITEMSIZE_OFFSET = 10;
    private static final int VLSN_OFFSET = 14;
    private long checksum;
    private byte entryType;
    private byte entryVersion;
    private long prevOffset;
    private int itemSize;
    private VLSN vlsn;
    private boolean isProvisional;
    private boolean replicate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LogEntryHeader(EnvironmentImpl envImpl, ByteBuffer entryBuffer, boolean anticipateChecksumErrors) throws DatabaseException {
        this.checksum = LogUtils.getUnsignedInt(entryBuffer);
        this.entryType = entryBuffer.get();
        if (!LogEntryType.isValidType(this.entryType)) {
            throw new DbChecksumException(anticipateChecksumErrors ? null : envImpl, "Read invalid log entry type: " + this.entryType);
        }
        this.entryVersion = entryBuffer.get();
        this.prevOffset = LogUtils.getUnsignedInt(entryBuffer);
        this.itemSize = LogUtils.readInt(entryBuffer);
        this.isProvisional = LogEntryType.isEntryProvisional(this.entryVersion);
        this.replicate = LogEntryType.isEntryReplicated(this.entryVersion);
    }

    LogEntryHeader(LogEntry entry, boolean isProvisional, boolean replicate) {
        LogEntryType logEntryType = entry.getLogType();
        this.entryType = logEntryType.getTypeNum();
        this.entryVersion = logEntryType.getVersion();
        this.itemSize = entry.getSize();
        this.isProvisional = isProvisional;
        this.replicate = replicate;
    }

    long getChecksum() {
        return this.checksum;
    }

    public byte getType() {
        return this.entryType;
    }

    public byte getVersion() {
        return this.entryVersion;
    }

    long getPrevOffset() {
        return this.prevOffset;
    }

    public int getItemSize() {
        return this.itemSize;
    }

    public boolean getReplicate() {
        return this.replicate;
    }

    int getVariablePortionSize() {
        return 16;
    }

    public int getSize() {
        if (this.replicate) {
            return 30;
        }
        return 14;
    }

    int getSizeMinusChecksum() {
        return this.getSize() - 4;
    }

    void readVariablePortion(ByteBuffer entryBuffer) throws LogException {
        if (this.replicate) {
            this.vlsn = new VLSN();
            this.vlsn.readFromLog(entryBuffer, this.entryVersion);
        }
    }

    void writeToLog(ByteBuffer entryBuffer) {
        entryBuffer.position(4);
        entryBuffer.put(this.entryType);
        if (this.isProvisional) {
            this.entryVersion = LogEntryType.setEntryProvisional(this.entryVersion);
        }
        if (this.replicate) {
            this.entryVersion = LogEntryType.setEntryReplicated(this.entryVersion);
        }
        entryBuffer.put(this.entryVersion);
        entryBuffer.position(10);
        LogUtils.writeInt(entryBuffer, this.itemSize);
        if (this.replicate) {
            entryBuffer.position(entryBuffer.position() + 16);
        }
    }

    ByteBuffer addPostMarshallingInfo(EnvironmentImpl envImpl, ByteBuffer entryBuffer, long lastOffset) {
        entryBuffer.position(6);
        LogUtils.writeUnsignedInt(entryBuffer, lastOffset);
        if (this.replicate) {
            entryBuffer.position(14);
            VLSN vlsn = envImpl.getReplicator().bumpVLSN();
            vlsn.writeToLog(entryBuffer);
        }
        Checksum checksum = Adler32.makeChecksum();
        checksum.update(entryBuffer.array(), entryBuffer.arrayOffset() + 4, entryBuffer.limit() - 4);
        entryBuffer.position(0);
        LogUtils.writeUnsignedInt(entryBuffer, checksum.getValue());
        entryBuffer.position(0);
        return entryBuffer;
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
    }

    void convertCommitToAbort(ByteBuffer entryBuffer) {
        if (!$assertionsDisabled && this.entryType != LogEntryType.LOG_TXN_COMMIT.getTypeNum()) {
            throw new AssertionError();
        }
        int itemStart = entryBuffer.position();
        int entryTypePosition = itemStart - (this.getSize() - 4);
        entryBuffer.position(entryTypePosition);
        entryBuffer.put(LogEntryType.LOG_TXN_ABORT.getTypeNum());
        Checksum checksum = Adler32.makeChecksum();
        int checksumSize = this.itemSize + (this.getSize() - 4);
        checksum.update(entryBuffer.array(), entryTypePosition + entryBuffer.arrayOffset(), checksumSize);
        entryBuffer.position(itemStart - this.getSize());
        LogUtils.writeUnsignedInt(entryBuffer, checksum.getValue());
    }

    static {
        $assertionsDisabled = !LogEntryHeader.class.desiredAssertionStatus();
    }
}

