/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.config.BooleanConfigParam;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.config.IntConfigParam;
import com.sleepycat.je.config.LongConfigParam;
import com.sleepycat.je.dbi.DbConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DbConfigManager {
    private static final String PROPFILE_NAME = "je.properties";
    private Properties props;
    private EnvironmentConfig environmentConfig;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DbConfigManager(EnvironmentConfig config) throws DbConfigException {
        this.environmentConfig = config;
        this.props = config == null ? new Properties() : DbInternal.getProps(config);
    }

    public void addConfigurations(Properties additionalProps) {
        this.props.putAll((Map<?, ?>)additionalProps);
    }

    public EnvironmentConfig getEnvironmentConfig() {
        return this.environmentConfig;
    }

    public synchronized String get(ConfigParam configParam) throws IllegalArgumentException {
        return DbConfigManager.getConfigParam(this.props, configParam.getName());
    }

    public synchronized String get(String configParamName) throws IllegalArgumentException {
        return DbConfigManager.getConfigParam(this.props, configParamName);
    }

    public boolean getBoolean(BooleanConfigParam configParam) throws DatabaseException {
        String val = this.get(configParam);
        return Boolean.valueOf(val);
    }

    public int getInt(IntConfigParam configParam) throws DatabaseException {
        int intValue;
        block3: {
            String val = this.get(configParam);
            intValue = 0;
            if (val != null) {
                try {
                    intValue = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        }
        return intValue;
    }

    public long getLong(LongConfigParam configParam) throws DatabaseException {
        long longValue;
        block3: {
            String val = this.get(configParam);
            longValue = 0L;
            if (val != null) {
                try {
                    longValue = Long.parseLong(val);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        }
        return longValue;
    }

    public static void validateProperties(Properties props, boolean forReplication, String configClassName) throws IllegalArgumentException {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(name);
            if (param == null) {
                throw new IllegalArgumentException(name + " is not a valid BDBJE environment configuration");
            }
            if (forReplication) {
                if (!param.isForReplication()) {
                    throw new IllegalArgumentException(name + " is not a replication environment configuration" + " and cannot be used in " + configClassName);
                }
            } else if (param.isForReplication()) {
                throw new IllegalArgumentException(name + " is a replication environment configuration" + " and cannot be used in " + configClassName);
            }
            param.validateValue(props.getProperty(name));
        }
    }

    public static void applyFileConfig(File envHome, Properties props, boolean forReplication, String errorClassName) throws IllegalArgumentException {
        File paramFile = null;
        try {
            Properties fileProps = new Properties();
            if (envHome != null) {
                paramFile = envHome.isFile() ? envHome : new File(envHome, PROPFILE_NAME);
                FileInputStream fis = new FileInputStream(paramFile);
                fileProps.load(fis);
                fis.close();
            }
            DbConfigManager.validateProperties(fileProps, forReplication, errorClassName);
            Iterator<Map.Entry<Object, Object>> iter = fileProps.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> propPair = iter.next();
                String name = (String)propPair.getKey();
                String value = (String)propPair.getValue();
                DbConfigManager.setConfigParam(props, name, value, false, false, forReplication);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            IllegalArgumentException e2 = new IllegalArgumentException("An error occurred when reading " + paramFile);
            e2.initCause(e);
            throw e2;
        }
    }

    public static void setConfigParam(Properties props, String paramName, String value, boolean requireMutability, boolean validateValue, boolean forReplication) throws IllegalArgumentException {
        ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param == null) {
            throw new IllegalArgumentException(paramName + " is not a valid BDBJE environment configuration");
        }
        if (forReplication) {
            if (!param.isForReplication()) {
                throw new IllegalArgumentException(paramName + " is not a BDBJE replication configuration.");
            }
        } else if (param.isForReplication()) {
            throw new IllegalArgumentException(paramName + " is only available for BDBJE replication.");
        }
        if (requireMutability && !param.isMutable()) {
            throw new IllegalArgumentException(paramName + " is not a mutable BDBJE environment configuration");
        }
        DbConfigManager.setVal(props, param, value, validateValue);
    }

    public static String getConfigParam(Properties props, String paramName) throws IllegalArgumentException {
        ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param == null) {
            throw new IllegalArgumentException(paramName + " is not a valid BDBJE environment configuration");
        }
        return DbConfigManager.getVal(props, param);
    }

    public static String getVal(Properties props, ConfigParam param) {
        String val = props.getProperty(param.getName());
        if (val == null) {
            val = param.getDefault();
        }
        return val;
    }

    public static void setVal(Properties props, ConfigParam param, String val, boolean validateValue) throws IllegalArgumentException {
        if (validateValue) {
            param.validateValue(val);
        }
        props.setProperty(param.getName(), val);
    }

    static {
        $assertionsDisabled = !DbConfigManager.class.desiredAssertionStatus();
    }
}

