/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.common.file.xml.XMLParser;
import be.yildizgames.engine.client.parser.ButtonDefinition;
import be.yildizgames.engine.client.parser.ContainerDefinition;
import be.yildizgames.engine.client.parser.GuiCommonDefinition;
import be.yildizgames.engine.client.parser.GuiParser;
import be.yildizgames.engine.client.parser.ImageDefinition;
import be.yildizgames.engine.client.parser.InputBoxDefinition;
import be.yildizgames.engine.client.parser.ParserException;
import be.yildizgames.engine.client.parser.TextAreaDefinition;
import be.yildizgames.engine.client.parser.TextLineDefinition;
import be.yildizgames.module.graphic.Font;
import be.yildizgames.module.graphic.material.Material;
import be.yildizgames.module.window.ScreenSize;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XmlGuiParser
implements GuiParser {
    private static final String CONTAINER = "container";
    private static final String NODE_Z = "z";
    private static final String MATERIAL = "material";
    private static final String MATERIAL_H = "materialH";
    private static final String FONT = "font";
    private static final String CHILDREN = "children";
    private static final String IMAGE = "image";
    private static final String INPUT_BOX = "input";
    private static final String TEXT_LINE = "textline";
    private static final String TEXT_AREA = "textarea";
    private static final String BUTTON = "button";
    private ScreenSize screen;

    XmlGuiParser(ScreenSize screen) {
        this.screen = screen;
    }

    private static void retrieveCommonData(NodeList list, GuiCommonDefinition def) throws ParserException {
        block14: for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String value = item.getTextContent();
            switch (item.getNodeName()) {
                case "name": {
                    def.setName(value);
                    continue block14;
                }
                case "x": {
                    def.setLeft(value);
                    continue block14;
                }
                case "y": {
                    def.setTop(value);
                    continue block14;
                }
                case "width": {
                    def.setWidth(value);
                    continue block14;
                }
                case "height": {
                    def.setHeight(value);
                    continue block14;
                }
            }
        }
    }

    @Override
    public List<ContainerDefinition> parse(Path xmlFile) throws ParserException {
        ArrayList<ContainerDefinition> resultList = new ArrayList<ContainerDefinition>();
        Document doc = XMLParser.getDocument((Path)xmlFile);
        NodeList viewList = doc.getElementsByTagName(CONTAINER);
        for (int i = 0; i < viewList.getLength(); ++i) {
            Node view = viewList.item(i);
            NodeList itemList = view.getChildNodes();
            ContainerDefinition def = new ContainerDefinition(this.screen);
            XmlGuiParser.retrieveCommonData(itemList, def);
            for (int j = 0; j < itemList.getLength(); ++j) {
                Node item = itemList.item(j);
                String itemName = item.getNodeName();
                if (itemName.equals(NODE_Z)) {
                    def.setZ(item.getTextContent());
                    continue;
                }
                if (itemName.equals(MATERIAL)) {
                    def.setMaterial(item.getTextContent());
                    continue;
                }
                if (!itemName.equals(CHILDREN)) continue;
                NodeList childrenList = item.getChildNodes();
                for (int k = 0; k < childrenList.getLength(); ++k) {
                    Node childItem;
                    int length;
                    String childItemName;
                    NodeList childItemList;
                    Node child = childrenList.item(k);
                    String childName = child.getNodeName();
                    if (childName.equals(IMAGE)) {
                        ImageDefinition imageDef = new ImageDefinition(this.screen);
                        childItemList = child.getChildNodes();
                        XmlGuiParser.retrieveCommonData(childItemList, imageDef);
                        int length2 = childItemList.getLength();
                        for (int l = 0; l < length2; ++l) {
                            Node childItem2 = childItemList.item(l);
                            childItemName = childItem2.getNodeName();
                            if (!childItemName.equals(MATERIAL)) continue;
                            imageDef.setMaterial(childItem2.getTextContent());
                        }
                        def.addImage(imageDef);
                        continue;
                    }
                    if (childName.equals(TEXT_LINE)) {
                        TextLineDefinition textLineDef = new TextLineDefinition(this.screen);
                        childItemList = child.getChildNodes();
                        XmlGuiParser.retrieveCommonData(childItemList, textLineDef);
                        int length3 = childItemList.getLength();
                        for (int l = 0; l < length3; ++l) {
                            Node childItem3 = childItemList.item(l);
                            childItemName = childItem3.getNodeName();
                            if (!childItemName.equals(FONT)) continue;
                            textLineDef.setFont(childItem3.getTextContent());
                        }
                        def.addTextLine(textLineDef);
                        continue;
                    }
                    if (childName.equals(BUTTON)) {
                        String material = "";
                        String highlight = "";
                        String font = "";
                        NodeList childItemList2 = child.getChildNodes();
                        length = childItemList2.getLength();
                        block25: for (int l = 0; l < length; ++l) {
                            childItem = childItemList2.item(l);
                            switch (childItem.getNodeName()) {
                                case "material": {
                                    material = childItem.getTextContent();
                                    continue block25;
                                }
                                case "materialH": {
                                    highlight = childItem.getTextContent();
                                    continue block25;
                                }
                                case "font": {
                                    font = childItem.getTextContent();
                                    continue block25;
                                }
                                default: {
                                    throw new ParserException("Invalid node: " + childItem.getNodeName());
                                }
                            }
                        }
                        ButtonDefinition buttonDef = new ButtonDefinition(material, highlight, font, this.screen);
                        XmlGuiParser.retrieveCommonData(childItemList2, buttonDef);
                        def.addButton(buttonDef);
                        continue;
                    }
                    if (childName.equals(INPUT_BOX)) {
                        NodeList childItemList3 = child.getChildNodes();
                        String material = "";
                        String highlight = "";
                        String font = "";
                        length = childItemList3.getLength();
                        block26: for (int l = 0; l < length; ++l) {
                            childItem = childItemList3.item(l);
                            switch (childItem.getNodeName()) {
                                case "material": {
                                    material = childItem.getTextContent();
                                    continue block26;
                                }
                                case "materialH": {
                                    highlight = childItem.getTextContent();
                                    continue block26;
                                }
                                case "font": {
                                    font = childItem.getTextContent();
                                    continue block26;
                                }
                            }
                        }
                        InputBoxDefinition inputDef = new InputBoxDefinition(Material.get((String)material), Material.get((String)highlight), Font.get((String)font), this.screen);
                        XmlGuiParser.retrieveCommonData(childItemList3, inputDef);
                        def.addInputBox(inputDef);
                        continue;
                    }
                    if (!childName.equals(TEXT_AREA)) continue;
                    TextAreaDefinition textAreaDef = new TextAreaDefinition(this.screen);
                    childItemList = child.getChildNodes();
                    XmlGuiParser.retrieveCommonData(childItemList, textAreaDef);
                    int length4 = childItemList.getLength();
                    for (int l = 0; l < length4; ++l) {
                        Node childItem4 = childItemList.item(l);
                        childItemName = childItem4.getNodeName();
                        if (childItemName.equals(MATERIAL)) {
                            textAreaDef.setMaterial(childItem4.getTextContent());
                            continue;
                        }
                        if (!childItemName.equals(FONT)) continue;
                        textAreaDef.setFont(childItem4.getTextContent());
                    }
                    def.addTextArea(textAreaDef);
                }
            }
            resultList.add(def);
        }
        return resultList;
    }
}

