/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.engine.client.parser.ParserException;
import be.yildizgames.module.coordinate.Coordinates;
import be.yildizgames.module.window.ScreenSize;
import java.util.HashMap;
import java.util.Map;

class GuiCommonDefinition {
    private static final Map<String, GuiCommonDefinition> DEFINITION_LIST = new HashMap<String, GuiCommonDefinition>();
    private final ScreenSize screenSize;
    private int left;
    private int width;
    private int top;
    private int height;
    private String name = "";
    private boolean leftNeedReposition;
    private String relativeLeftPos;
    private boolean topNeedReposition;
    private String relativeTopPos;

    GuiCommonDefinition(ScreenSize screen) {
        this.screenSize = screen;
    }

    public final Coordinates getCoordinates() {
        return new Coordinates(this.width, this.height, this.left, this.top);
    }

    final void setWidth(String widgetWidth) throws ParserException {
        if (widgetWidth.contains("full")) {
            String[] args = widgetWidth.split("-");
            if (args.length == 1) {
                this.width = this.screenSize.width;
            } else {
                try {
                    this.width = this.screenSize.width - Integer.parseInt(args[1]);
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException("Invalid width value:", nfe);
                }
            }
        } else {
            try {
                this.width = Integer.parseInt(widgetWidth);
            }
            catch (NumberFormatException nfe) {
                throw new ParserException("Invalid width value:", nfe);
            }
        }
        if (this.width == 0) {
            throw new ParserException("Width of zero is now allowed.");
        }
        if (this.leftNeedReposition) {
            this.setLeft(this.relativeLeftPos);
            this.leftNeedReposition = false;
        }
    }

    final void setHeight(String widgetHeight) throws ParserException {
        if (widgetHeight.contains("full")) {
            String[] args = widgetHeight.split("-");
            if (args.length == 1) {
                this.height = this.screenSize.height;
            } else {
                try {
                    this.height = this.screenSize.height - Integer.parseInt(args[1]);
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException("Invalid height value:", nfe);
                }
            }
        } else {
            try {
                this.height = Integer.parseInt(widgetHeight);
            }
            catch (NumberFormatException nfe) {
                throw new ParserException("Invalid height value:", nfe);
            }
        }
        if (this.height == 0) {
            throw new ParserException("Height of zero is now allowed.");
        }
        if (this.topNeedReposition) {
            this.setTop(this.relativeTopPos);
            this.topNeedReposition = false;
        }
    }

    final void setLeft(String leftValue) throws ParserException {
        String[] values = leftValue.split("#");
        switch (values[0]) {
            case "left": {
                if (values.length > 1) {
                    GuiCommonDefinition other = DEFINITION_LIST.get(values[1]);
                    this.left = other.left - other.width;
                    break;
                }
                this.left = 0;
                break;
            }
            case "right": {
                if (this.width != 0) {
                    if (values.length == 1) {
                        this.left = this.screenSize.width - this.width;
                        break;
                    }
                    GuiCommonDefinition other = DEFINITION_LIST.get(values[1]);
                    this.left = other.left + other.width;
                    break;
                }
                this.leftNeedReposition = true;
                this.relativeLeftPos = leftValue;
                break;
            }
            case "center": {
                if (this.width != 0) {
                    if (values.length != 1) break;
                    this.left = (this.screenSize.width >> 1) - (this.width >> 1);
                    break;
                }
                this.leftNeedReposition = true;
                this.relativeLeftPos = leftValue;
                break;
            }
            default: {
                try {
                    this.left = Integer.parseInt(values[0]);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException("Invalid left value:", nfe);
                }
            }
        }
    }

    final void setTop(String topValue) throws ParserException {
        switch (topValue) {
            case "top": {
                this.top = 0;
                break;
            }
            case "bottom": {
                if (this.height != 0) {
                    this.top = this.screenSize.height - this.height;
                    break;
                }
                this.topNeedReposition = true;
                this.relativeTopPos = topValue;
                break;
            }
            default: {
                try {
                    this.top = Integer.parseInt(topValue);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException("Invalid top value:", nfe);
                }
            }
        }
    }

    final void setName(String widgetName) {
        this.name = widgetName;
        DEFINITION_LIST.put(this.name, this);
    }

    public String getName() {
        return this.name;
    }
}

