/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.itunesapi;

import be.ceau.itunesapi.http.Connector;
import be.ceau.itunesapi.http.URLConnector;
import be.ceau.itunesapi.request.Country;
import be.ceau.itunesapi.request.Entity;
import be.ceau.itunesapi.request.search.Attribute;
import be.ceau.itunesapi.request.search.Lang;
import be.ceau.itunesapi.request.search.Media;
import be.ceau.itunesapi.response.Response;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Search.class);
    private static final long serialVersionUID = 1476515615735L;
    private static final String API_ENDPOINT = "https://itunes.apple.com/search?";
    private String term;
    private Country country;
    private Media media;
    private Entity entity;
    private Attribute attribute;
    private Integer limit;
    private Lang lang;
    private Integer version;
    private Boolean explicit;

    public Search() {
    }

    public Search(String term) {
        this.term = term;
    }

    public Response execute() {
        return this.execute(URLConnector.INSTANCE);
    }

    public Response execute(Connector connector) {
        if (connector == null) {
            throw new IllegalArgumentException("connector can not be null");
        }
        try {
            String url = this.build();
            String response = connector.get(url);
            logger.trace("{} -> {}", (Object)url, (Object)response);
            return (Response)Response.READER.readValue(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTerm() {
        return this.term;
    }

    public Search setTerm(String term) {
        this.term = term;
        return this;
    }

    public Country getCountry() {
        return this.country;
    }

    public Search setCountry(Country country) {
        this.country = country;
        return this;
    }

    public Media getMedia() {
        return this.media;
    }

    public Search setMedia(Media media) {
        this.media = media;
        return this;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Search setEntity(Entity entity) {
        this.entity = entity;
        return this;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Search setAttribute(Attribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Search setLimit(int limit) {
        if (limit < 1 || limit > 200) {
            throw new IllegalArgumentException("limit must be between 1 and 200");
        }
        this.limit = limit;
        return this;
    }

    public Lang getLang() {
        return this.lang;
    }

    public Search setLang(Lang lang) {
        this.lang = lang;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Search setVersion(int version) {
        if (version != 1 && version != 2) {
            throw new IllegalArgumentException("version must be 1 or 2");
        }
        this.version = version;
        return this;
    }

    public Boolean isExplicit() {
        return this.explicit;
    }

    public Search setExplicit(boolean explicit) {
        this.explicit = explicit;
        return this;
    }

    public String build() {
        return API_ENDPOINT + this.termParam() + this.countryParam() + this.mediaParam() + this.entityParam() + this.attributeParam() + this.limitParam() + this.langParam() + this.versionParam() + this.explicitParam();
    }

    private String termParam() {
        if (this.term == null) {
            throw new IllegalStateException("you must provide a search term");
        }
        String t = this.term.trim();
        try {
            t = URLEncoder.encode(t, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (t.length() == 0) {
            throw new IllegalStateException("you must provide a search term");
        }
        return "term=" + t;
    }

    private String countryParam() {
        if (this.country != null) {
            return "&country=" + this.country.getIso();
        }
        return "";
    }

    private String mediaParam() {
        if (this.media != null) {
            return "&media=" + this.media.getName();
        }
        return "";
    }

    private String entityParam() {
        if (this.entity != null) {
            return "&entity=" + this.entity.getName();
        }
        return "";
    }

    private String attributeParam() {
        if (this.attribute != null) {
            return "&attribute=" + this.attribute.getName();
        }
        return "";
    }

    private String limitParam() {
        if (this.limit != null) {
            return "&limit=" + this.limit;
        }
        return "";
    }

    private String langParam() {
        if (this.lang != null) {
            return "&lang=" + this.lang.getCode();
        }
        return "";
    }

    private String versionParam() {
        if (this.version != null) {
            return "&version=" + this.version;
        }
        return "";
    }

    private String explicitParam() {
        if (this.explicit != null) {
            return this.explicit != false ? "&explicit=Yes" : "&explicit=No";
        }
        return "";
    }
}

