/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.axis2.transport.http.server.RequestLine;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.NameValuePair;

public class SimpleRequest {
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private RequestLine requestLine = null;
    private HeaderGroup headers = new HeaderGroup();
    private InputStream entity = null;

    public SimpleRequest() {
    }

    public SimpleRequest(RequestLine requestLine, Header[] headers) throws IOException {
        this(requestLine, headers, null);
    }

    public SimpleRequest(RequestLine requestLine, Header[] headers, InputStream content) throws IOException {
        String methodname;
        if (requestLine == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        this.requestLine = requestLine;
        if (headers != null) {
            this.headers.setHeaders(headers);
        }
        if (content != null && ("POST".equalsIgnoreCase(methodname = requestLine.getMethod()) || "PUT".equalsIgnoreCase(methodname))) {
            long len;
            Header contentLength = this.headers.getFirstHeader("Content-Length");
            Header transferEncoding = this.headers.getFirstHeader("Transfer-Encoding");
            InputStream in = content;
            if (transferEncoding != null) {
                if (transferEncoding.getValue().indexOf("chunked") != -1) {
                    in = new ChunkedInputStream(in);
                }
            } else if (contentLength != null && (len = this.getContentLength()) >= 0L) {
                in = new ContentLengthInputStream(in, len);
            }
            this.entity = in;
        }
    }

    public void addHeader(Header header) {
        if (header == null) {
            return;
        }
        this.headers.addHeader(header);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public void removeHeaders(String s) {
        if (s == null) {
            return;
        }
        Header[] headers = this.headers.getHeaders(s);
        for (int i = 0; i < headers.length; ++i) {
            this.headers.removeHeader(headers[i]);
        }
    }

    public InputStream getBody() {
        return this.entity;
    }

    public byte[] getBodyBytes() throws IOException {
        InputStream in = this.getBody();
        if (in != null) {
            byte[] tmp = new byte[4096];
            int bytesRead = 0;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
            while ((bytesRead = in.read(tmp)) != -1) {
                buffer.write(tmp, 0, bytesRead);
            }
            return buffer.toByteArray();
        }
        return null;
    }

    public String getBodyString() throws IOException {
        byte[] raw = this.getBodyBytes();
        if (raw != null) {
            return new String(raw, this.getCharset());
        }
        return null;
    }

    public String getCharset() {
        NameValuePair param;
        HeaderElement[] values;
        String charset = null;
        Header contenttype = this.headers.getFirstHeader("Content-Type");
        if (contenttype != null && (values = contenttype.getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        if (charset != null) {
            return charset;
        }
        return DEFAULT_CONTENT_CHARSET;
    }

    public long getContentLength() {
        Header contentLength = this.headers.getFirstHeader("Content-Length");
        if (contentLength != null) {
            try {
                return Long.parseLong(contentLength.getValue());
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public String getContentType() {
        Header contenttype = this.headers.getFirstHeader("Content-Type");
        if (contenttype != null) {
            return contenttype.getValue();
        }
        return "text/plain";
    }

    public String getCookieID() {
        Header cookieHeader = this.headers.getFirstHeader("Cookie");
        if (cookieHeader == null) {
            cookieHeader = this.headers.getFirstHeader("Cookie2");
        }
        if (cookieHeader == null) {
            return null;
        }
        return cookieHeader.getValue();
    }

    public Header getFirstHeader(String s) {
        return this.headers.getFirstHeader(s);
    }

    public Iterator getHeaderIterator() {
        return this.headers.getIterator();
    }

    public Header[] getHeaders() {
        return this.headers.getAllHeaders();
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setHeader(Header header) {
        if (header == null) {
            return;
        }
        this.removeHeaders(header.getName());
        this.addHeader(header);
    }

    public void setRequestLine(RequestLine requestline) {
        if (requestline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        this.requestLine = requestline;
    }
}

