/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.wsdl.codegen.extension.AbstractDBProcessingExtension;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;

public class JiBXExtension
extends AbstractDBProcessingExtension {
    public static final String BINDING_PATH_OPTION = "bindingfile";
    public static final String JIBX_MODEL_CLASS = "org.jibx.binding.model.BindingElement";
    public static final String JIBX_UTILITY_CLASS = "org.apache.axis2.jibx.CodeGenerationUtility";
    public static final String BINDING_MAP_METHOD = "getBindingMap";

    public void engage() {
        if (this.testFallThrough(this.configuration.getDatabindingType())) {
            return;
        }
        String path = (String)this.configuration.getProperties().get(BINDING_PATH_OPTION);
        if (path == null) {
            throw new RuntimeException("jibx binding option requires -bindingfile {file path} parameter");
        }
        try {
            try {
                this.getClass().getClassLoader().loadClass(JIBX_MODEL_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("JiBX framework jars not in classpath");
            }
            Class<?> clazz = null;
            try {
                clazz = JiBXExtension.class.getClassLoader().loadClass(JIBX_UTILITY_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("JiBX binding extension not in classpath");
            }
            Method method = clazz.getMethod(BINDING_MAP_METHOD, String.class);
            HashMap jibxmap = (HashMap)method.invoke(null, path);
            HashSet elements = new HashSet();
            Iterator operations = this.configuration.getAxisService().getOperations();
            while (operations.hasNext()) {
                AxisOperation o = (AxisOperation)operations.next();
                this.accumulateElements(o, elements);
            }
            JavaTypeMapper mapper = new JavaTypeMapper();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                QName qname = (QName)iter.next();
                if (qname == null) continue;
                String cname = (String)jibxmap.get(qname);
                if (cname == null) {
                    throw new RuntimeException("No JiBX mapping defined for " + qname);
                }
                mapper.addTypeMappingName(qname, cname);
            }
            this.configuration.setTypeMapper(mapper);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void accumulateElements(AxisOperation op, HashSet elements) {
        AxisMessage outAxisMessage;
        AxisMessage inaxisMessage;
        String MEP = op.getMessageExchangePattern();
        if (("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (inaxisMessage = op.getMessage("In")) != null) {
            elements.add(inaxisMessage.getElementQName());
        }
        if (("http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (outAxisMessage = op.getMessage("Out")) != null) {
            elements.add(outAxisMessage.getElementQName());
        }
    }
}

