/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.databinding.types.Day;
import org.apache.axis2.databinding.types.Duration;
import org.apache.axis2.databinding.types.Entities;
import org.apache.axis2.databinding.types.Entity;
import org.apache.axis2.databinding.types.HexBinary;
import org.apache.axis2.databinding.types.IDRef;
import org.apache.axis2.databinding.types.IDRefs;
import org.apache.axis2.databinding.types.Id;
import org.apache.axis2.databinding.types.Language;
import org.apache.axis2.databinding.types.Month;
import org.apache.axis2.databinding.types.MonthDay;
import org.apache.axis2.databinding.types.NCName;
import org.apache.axis2.databinding.types.NMToken;
import org.apache.axis2.databinding.types.NMTokens;
import org.apache.axis2.databinding.types.Name;
import org.apache.axis2.databinding.types.NegativeInteger;
import org.apache.axis2.databinding.types.NonNegativeInteger;
import org.apache.axis2.databinding.types.NonPositiveInteger;
import org.apache.axis2.databinding.types.NormalizedString;
import org.apache.axis2.databinding.types.Notation;
import org.apache.axis2.databinding.types.PositiveInteger;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.types.Token;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.UnsignedByte;
import org.apache.axis2.databinding.types.UnsignedInt;
import org.apache.axis2.databinding.types.UnsignedLong;
import org.apache.axis2.databinding.types.UnsignedShort;
import org.apache.axis2.databinding.types.Year;
import org.apache.axis2.databinding.types.YearMonth;
import org.apache.axis2.util.Base64;

public class ConverterUtil {
    private static final String POSITIVE_INFINITY = "INF";
    private static final String NEGATIVE_INFINITY = "-INF";

    public static String convertToString(int i) {
        return i + "";
    }

    public static String convertToString(float i) {
        return i + "";
    }

    public static String convertToString(long i) {
        return i + "";
    }

    public static String convertToString(double i) {
        return i + "";
    }

    public static String convertToString(byte i) {
        return i + "";
    }

    public static String convertToString(char i) {
        return new String(new char[]{i});
    }

    public static String convertToString(short i) {
        return i + "";
    }

    public static String convertToString(boolean i) {
        return i + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToString(Date value) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer buf = new StringBuffer();
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            if (calendar.get(0) == 0) {
                buf.append("-");
                calendar.setTime(value);
                calendar.set(0, 1);
                value = calendar.getTime();
            }
            buf.append(zulu.format(value));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToString(Calendar value) {
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Date date = value.getTime();
        SimpleDateFormat simpleDateFormat = zulu;
        synchronized (simpleDateFormat) {
            return zulu.format(date);
        }
    }

    public static String convertToString(Day o) {
        return o.toString();
    }

    public static String convertToString(YearMonth o) {
        return o.toString();
    }

    public static String convertToString(Year o) {
        return o.toString();
    }

    public static String convertToString(HexBinary o) {
        return o.toString();
    }

    public static String convertToString(MonthDay o) {
        return o.toString();
    }

    public static String convertToString(Time o) {
        return o.toString();
    }

    public static String convertToString(Byte o) {
        return o.toString();
    }

    public static String convertToString(BigInteger o) {
        return o.toString();
    }

    public static String convertToString(Integer o) {
        return o.toString();
    }

    public static String convertToString(Long o) {
        return o.toString();
    }

    public static String convertToString(Short o) {
        return o.toString();
    }

    public static String convertToString(UnsignedByte o) {
        return o.toString();
    }

    public static String convertToString(UnsignedInt o) {
        return o.toString();
    }

    public static String convertToString(UnsignedLong o) {
        return o.toString();
    }

    public static String convertToString(Object o) {
        return o.toString();
    }

    public static String convertToString(Double o) {
        return o.toString();
    }

    public static String convertToString(Duration o) {
        return o.toString();
    }

    public static String convertToString(Float o) {
        return o.toString();
    }

    public static String convertToString(Month o) {
        return o.toString();
    }

    public static String convertToString(byte[] bytes) {
        return Base64.encode((byte[])bytes);
    }

    public static String convertToString(DataHandler handler) {
        return ConverterUtil.getStringFromDatahandler(handler);
    }

    public static int convertToint(String s) {
        return Integer.parseInt(s);
    }

    public static double convertTodouble(String s) {
        if (POSITIVE_INFINITY.equals(s)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(s);
    }

    public static BigDecimal convertTodecimal(String s) {
        return new BigDecimal(s);
    }

    public static float convertTofloat(String s) {
        if (POSITIVE_INFINITY.equals(s)) {
            return Float.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(s);
    }

    public static String convertTostring(String s) {
        return s;
    }

    public static long convertTolong(String s) {
        return Long.parseLong(s);
    }

    public static short convertToshort(String s) {
        return Short.parseShort(s);
    }

    public static boolean convertToboolean(String s) {
        return Boolean.valueOf(s);
    }

    public static String convertToanySimpleType(String s) {
        return s;
    }

    public static OMElement convertToanyType(String s) {
        try {
            XMLStreamReader r = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(s.getBytes()));
            StAXOMBuilder builder = new StAXOMBuilder(OMAbstractFactory.getOMFactory(), r);
            return builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    public static YearMonth convertTogYearMonth(String s) {
        return new YearMonth(s);
    }

    public static MonthDay convertTogMonthDay(String s) {
        return new MonthDay(s);
    }

    public static Year convertTogYear(String s) {
        return new Year(s);
    }

    public static Month convertTogMonth(String s) {
        return new Month(s);
    }

    public static Day convertTogDay(String s) {
        return new Day(s);
    }

    public static Duration convertToduration(String s) {
        return new Duration(s);
    }

    public static Duration convertToDuration(String s) {
        return new Duration(s);
    }

    public static HexBinary convertTohexBinary(String s) {
        return new HexBinary(s);
    }

    public static DataHandler convertTobase64Binary(String s) throws Exception {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(s.getBytes());
        return new DataHandler((DataSource)byteArrayDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date convertTodate(String source) {
        Date result;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
        boolean bc = false;
        if (source != null) {
            if (source.charAt(0) == '+') {
                source = source.substring(1);
            }
            if (source.charAt(0) == '-') {
                source = source.substring(1);
                bc = true;
            }
            if (source.length() < 10) {
                throw new NumberFormatException("bad date format");
            }
            if (source.charAt(4) != '-' || source.charAt(7) != '-') {
                throw new NumberFormatException("bad Date format");
            }
        }
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            try {
                result = zulu.parse(source == null ? null : source.substring(0, 10));
            }
            catch (Exception e) {
                throw new NumberFormatException(e.toString());
            }
            if (bc) {
                calendar.setTime(result);
                calendar.set(0, 0);
                result = calendar.getTime();
            }
        }
        return result;
    }

    public static Time convertTotime(String s) {
        return new Time(s);
    }

    public static Token convertTotoken(String s) {
        return new Token(s);
    }

    public static NormalizedString convertTonormalizedString(String s) {
        return new NormalizedString(s);
    }

    public static UnsignedLong convertTounsignedLong(String s) {
        return new UnsignedLong(s);
    }

    public static UnsignedInt convertTounsignedInt(String s) {
        return new UnsignedInt(s);
    }

    public static UnsignedShort convertTounsignedShort(String s) {
        return new UnsignedShort(s);
    }

    public static UnsignedByte convertTounsignedByte(String s) {
        return new UnsignedByte(s);
    }

    public static NonNegativeInteger convertTononNegativeInteger(String s) {
        return new NonNegativeInteger(s);
    }

    public static NegativeInteger convertTonegativeInteger(String s) {
        return new NegativeInteger(s);
    }

    public static PositiveInteger convertTopositiveInteger(String s) {
        return new PositiveInteger(s);
    }

    public static NonPositiveInteger convertTononPositiveInteger(String s) {
        return new NonPositiveInteger(s);
    }

    public static Name convertToName(String s) {
        return new Name(s);
    }

    public static NCName convertToNCName(String s) {
        return new NCName(s);
    }

    public static Id convertToID(String s) {
        return new Id(s);
    }

    public static Language convertTolanguage(String s) {
        return new Language(s);
    }

    public static NMToken convertToNMTOKEN(String s) {
        return new NMToken(s);
    }

    public static NMTokens convertToNMTOKENS(String s) {
        return new NMTokens(s);
    }

    public static Notation convertToNOTATION(String s) {
        return null;
    }

    public static Entity convertToENTITY(String s) {
        return new Entity(s);
    }

    public static Entities convertToENTITIES(String s) {
        return new Entities(s);
    }

    public static IDRef convertToIDREF(String s) {
        return new IDRef(s);
    }

    public static IDRefs convertToIDREFS(String s) {
        return new IDRefs(s);
    }

    public static URI convertToanyURI(String s) throws Exception {
        return new URI(s);
    }

    public static BigInteger convertTointeger(String s) throws Exception {
        return new BigInteger(s);
    }

    public static byte convertTobyte(String s) throws Exception {
        return Byte.parseByte(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar convertTodateTime(String source) throws Exception {
        Date date;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        boolean bc = false;
        if (source == null || source.length() == 0) {
            throw new NumberFormatException();
        }
        if (source.charAt(0) == '+') {
            source = source.substring(1);
        }
        if (source.charAt(0) == '-') {
            source = source.substring(1);
            bc = true;
        }
        if (source.length() < 19) {
            throw new NumberFormatException();
        }
        if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T') {
            throw new NumberFormatException();
        }
        if (source.charAt(13) != ':' || source.charAt(16) != ':') {
            throw new NumberFormatException();
        }
        try {
            SimpleDateFormat simpleDateFormat = zulu;
            synchronized (simpleDateFormat) {
                date = zulu.parse(source.substring(0, 19) + ".000Z");
            }
        }
        catch (Exception e) {
            throw new NumberFormatException(e.toString());
        }
        int pos = 19;
        if (pos < source.length() && source.charAt(pos) == '.') {
            int milliseconds = 0;
            int start = ++pos;
            while (pos < source.length() && Character.isDigit(source.charAt(pos))) {
                ++pos;
            }
            String decimal = source.substring(start, pos);
            if (decimal.length() == 3) {
                milliseconds = Integer.parseInt(decimal);
            } else if (decimal.length() < 3) {
                milliseconds = Integer.parseInt((decimal + "000").substring(0, 3));
            } else {
                milliseconds = Integer.parseInt(decimal.substring(0, 3));
                if (decimal.charAt(3) >= '5') {
                    ++milliseconds;
                }
            }
            date.setTime(date.getTime() + (long)milliseconds);
        }
        if (pos + 5 < source.length() && (source.charAt(pos) == '+' || source.charAt(pos) == '-')) {
            if (!(Character.isDigit(source.charAt(pos + 1)) && Character.isDigit(source.charAt(pos + 2)) && source.charAt(pos + 3) == ':' && Character.isDigit(source.charAt(pos + 4)) && Character.isDigit(source.charAt(pos + 5)))) {
                throw new NumberFormatException();
            }
            int hours = (source.charAt(pos + 1) - 48) * 10 + source.charAt(pos + 2) - 48;
            int mins = (source.charAt(pos + 4) - 48) * 10 + source.charAt(pos + 5) - 48;
            int milliseconds = (hours * 60 + mins) * 60 * 1000;
            if (source.charAt(pos) == '+') {
                milliseconds = -milliseconds;
            }
            date.setTime(date.getTime() + (long)milliseconds);
            pos += 6;
        }
        if (pos < source.length() && source.charAt(pos) == 'Z') {
            ++pos;
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        if (pos < source.length()) {
            throw new NumberFormatException();
        }
        calendar.setTime(date);
        if (bc) {
            calendar.set(0, 0);
        }
        return calendar;
    }

    public static QName convertToQName(String source) {
        int colon = (source = source.trim()).lastIndexOf(":");
        String namespace = colon < 0 ? "" : "";
        String localPart = colon < 0 ? source : source.substring(colon + 1);
        return new QName(namespace, localPart);
    }

    public static Object convertToObject(String i) {
        return i;
    }

    public static Object convertToObject(boolean i) {
        return i;
    }

    public static Object convertToObject(double i) {
        return new Double(i);
    }

    public static Object convertToObject(byte i) {
        return new Byte(i);
    }

    public static Object convertToObject(char i) {
        return new Character(i);
    }

    public static Object convertToObject(short i) {
        return new Short(i);
    }

    public static Object convertToArray(Class baseArrayClass, String[] valueArray) {
        ArrayList<String> valuesList = new ArrayList<String>(valueArray.length);
        for (int i = 0; i < valueArray.length; ++i) {
            valuesList.add(valueArray[i]);
        }
        return ConverterUtil.convertToArray(baseArrayClass, valuesList);
    }

    public static Object convertToArray(Class baseArrayClass, List objectList) {
        int listSize = objectList.size();
        Object returnArray = Array.newInstance(baseArrayClass, listSize);
        if (Integer.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Array.setInt(returnArray, i, Integer.parseInt(objectList.get(i).toString()));
            }
        } else if (Float.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Array.setFloat(returnArray, i, Float.parseFloat(objectList.get(i).toString()));
            }
        } else if (Short.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Array.setShort(returnArray, i, Short.parseShort(objectList.get(i).toString()));
            }
        } else if (Long.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Array.setLong(returnArray, i, Long.parseLong(objectList.get(i).toString()));
            }
        } else if (Boolean.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Array.setBoolean(returnArray, i, Boolean.getBoolean(objectList.get(i).toString()));
            }
        } else if (Character.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Array.setChar(returnArray, i, objectList.get(i).toString().toCharArray()[0]);
            }
        } else if (Double.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Array.setDouble(returnArray, i, Double.parseDouble(objectList.get(i).toString()));
            }
        } else {
            objectList.toArray((Object[])returnArray);
        }
        return returnArray;
    }

    public static List toList(Object[] array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static String getStringFromDatahandler(DataHandler dataHandler) {
        try {
            InputStream inStream = dataHandler.getDataSource().getInputStream();
            StringBuffer text = new StringBuffer();
            do {
                int len;
                byte[] data = new byte[1024];
                while ((len = inStream.read(data)) > 0) {
                    byte[] temp = new byte[len];
                    System.arraycopy(data, 0, temp, 0, len);
                    text.append(Base64.encode((byte[])temp));
                }
            } while (inStream.available() > 0);
            return text.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

