/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.value.FontSpecification;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.java2d.Java2DFont;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.FontFaceFontSupplier;
import com.openhtmltopdf.outputdevice.helper.FontFamily;
import com.openhtmltopdf.outputdevice.helper.FontResolverHelper;
import com.openhtmltopdf.outputdevice.helper.MinimalFontDescription;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

public class Java2DFontResolver
implements FontResolver {
    private final HashMap<String, Font> instanceHash = new HashMap();
    private final HashMap<String, Font> availableFontsHash = new HashMap();
    private final SharedContext _sharedContext;
    private final HashMap<String, FontFamily<FontDescription>> _fontFamilies = new HashMap();

    public Java2DFontResolver(SharedContext sharedCtx, boolean useEnvironmentFonts) {
        this._sharedContext = sharedCtx;
        if (useEnvironmentFonts) {
            this.init();
        }
    }

    private void init() {
        String[] availableFonts;
        GraphicsEnvironment gfx = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String fontName : availableFonts = gfx.getAvailableFontFamilyNames()) {
            this.availableFontsHash.put(fontName, null);
        }
        this.availableFontsHash.put("Serif", new Font("Serif", 0, 1));
        this.availableFontsHash.put("SansSerif", new Font("SansSerif", 0, 1));
        this.availableFontsHash.put("Monospaced", new Font("Monospaced", 0, 1));
    }

    @Deprecated
    public void flushCache() {
        this.instanceHash.clear();
        this.availableFontsHash.clear();
        this._fontFamilies.clear();
        this.init();
    }

    public void importFontFaces(List<FontFaceRule> fontFaces) {
        for (FontFaceRule rule : fontFaces) {
            CalculatedStyle style = rule.getCalculatedStyle();
            FSDerivedValue src = style.valueByName(CSSName.SRC);
            if (src == IdentValue.NONE) continue;
            String fontFamily = null;
            IdentValue fontWeight = null;
            IdentValue fontStyle = null;
            if (!rule.hasFontFamily()) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.CSS_PARSE_MUST_PROVIDE_AT_LEAST_A_FONT_FAMILY_AND_SRC_IN_FONT_FACE_RULE);
                continue;
            }
            fontFamily = style.valueByName(CSSName.FONT_FAMILY).asString();
            if (rule.hasFontWeight()) {
                fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
            }
            if (rule.hasFontStyle()) {
                fontStyle = style.getIdent(CSSName.FONT_STYLE);
            }
            this.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString());
        }
    }

    public void addInputStreamFont(FSSupplier<InputStream> fontSupplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride) {
        FontFamily<FontDescription> fontFamily = this.getFontFamily(fontFamilyNameOverride);
        InputStreamFontDescription descr = new InputStreamFontDescription(fontSupplier, fontWeightOverride != null ? fontWeightOverride : 400, fontStyleOverride != null ? fontStyleOverride : IdentValue.NORMAL);
        fontFamily.addFontDescription((MinimalFontDescription)descr);
    }

    private void addFontFaceFont(String fontFamilyNameOverride, IdentValue fontWeightOverride, IdentValue fontStyleOverride, String uri) {
        FontFaceFontSupplier fontSupplier = new FontFaceFontSupplier(this._sharedContext, uri);
        this.addInputStreamFont((FSSupplier<InputStream>)fontSupplier, fontFamilyNameOverride, fontWeightOverride != null ? FontResolverHelper.convertWeightToInt((IdentValue)fontWeightOverride) : 400, fontStyleOverride);
    }

    public void addFontFile(File fontFile, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride) {
        FontFamily<FontDescription> fontFamily = this.getFontFamily(fontFamilyNameOverride);
        FileFontDescription descr = new FileFontDescription(fontFile, fontWeightOverride != null ? fontWeightOverride : 400, fontStyleOverride != null ? fontStyleOverride : IdentValue.NORMAL);
        fontFamily.addFontDescription((MinimalFontDescription)descr);
    }

    private FontFamily<FontDescription> getFontFamily(String fontFamilyName) {
        FontFamily fontFamily = this._fontFamilies.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily(fontFamilyName);
            this._fontFamilies.put(fontFamilyName, (FontFamily<FontDescription>)fontFamily);
        }
        return fontFamily;
    }

    private String normalizeFontFamily(String fontFamily) {
        String result = fontFamily;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.equalsIgnoreCase("serif")) {
            result = "Serif";
        } else if (result.equalsIgnoreCase("sans-serif")) {
            result = "SansSerif";
        } else if (result.equalsIgnoreCase("monospace")) {
            result = "Monospaced";
        }
        return result;
    }

    private Font resolveFontFaceBaseFont(String normalizedFontFamily, float size, IdentValue weight, IdentValue style) {
        FontDescription result;
        FontFamily<FontDescription> fontFamily = this._fontFamilies.get(normalizedFontFamily);
        if (fontFamily != null && (result = (FontDescription)fontFamily.match(FontResolverHelper.convertWeightToInt((IdentValue)weight), style)) != null && result.realizeFont()) {
            return result.getBaseFont();
        }
        return null;
    }

    public FSFont resolveFont(SharedContext ctx, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        ArrayList<Font> fonts = new ArrayList<Font>(3);
        if (families != null) {
            for (int i = 0; i < families.length; ++i) {
                String normal = this.normalizeFontFamily(families[i]);
                String fontInstanceName = Java2DFontResolver.getFontInstanceHashName(ctx, normal, size, weight, style, variant);
                if (this.instanceHash.containsKey(fontInstanceName)) {
                    fonts.add(this.instanceHash.get(fontInstanceName));
                    continue;
                }
                Font baseFont = this.resolveFontFaceBaseFont(normal, size, weight, style);
                if (baseFont != null) {
                    Font derivedFont = baseFont.deriveFont(0, size);
                    this.instanceHash.put(fontInstanceName, derivedFont);
                    fonts.add(derivedFont);
                    continue;
                }
                if (!this.availableFontsHash.containsKey(normal)) continue;
                Font possiblyNullFont = this.availableFontsHash.get(normal);
                Font rootFont = null;
                if (possiblyNullFont != null) {
                    rootFont = possiblyNullFont;
                } else {
                    rootFont = new Font(normal, 0, 1);
                    this.availableFontsHash.put(normal, rootFont);
                }
                Font fnt = Java2DFontResolver.createFont(ctx, rootFont, size, weight, style, variant);
                this.instanceHash.put(fontInstanceName, fnt);
                fonts.add(fnt);
            }
        }
        if (this.availableFontsHash.containsKey("Serif")) {
            Font fnt = Java2DFontResolver.createFont(ctx, this.availableFontsHash.get("Serif"), size, weight, style, variant);
            this.instanceHash.put(Java2DFontResolver.getFontInstanceHashName(ctx, "Serif", size, weight, style, variant), fnt);
            fonts.add(fnt);
        }
        return new Java2DFont(fonts, size);
    }

    public void setFontMapping(String name, Font font) {
        this.availableFontsHash.put(name, font.deriveFont(1.0f));
    }

    protected static Font createFont(SharedContext ctx, Font rootFont, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        int fontConst = 0;
        if (weight != null && (weight == IdentValue.BOLD || weight == IdentValue.FONT_WEIGHT_700 || weight == IdentValue.FONT_WEIGHT_800 || weight == IdentValue.FONT_WEIGHT_900)) {
            fontConst |= 1;
        }
        if (style != null && (style == IdentValue.ITALIC || style == IdentValue.OBLIQUE)) {
            fontConst |= 2;
        }
        Font fnt = rootFont.deriveFont(fontConst, size);
        if (variant != null && variant == IdentValue.SMALL_CAPS) {
            fnt = fnt.deriveFont((float)((double)fnt.getSize() * 0.6));
        }
        return fnt;
    }

    protected static String getFontInstanceHashName(SharedContext ctx, String name, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        return name + "-" + size + "-" + weight + "-" + style + "-" + variant;
    }

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(renderingContext, spec.families, spec.size, spec.fontWeight, spec.fontStyle, spec.variant);
    }

    private static class FileFontDescription
    extends FontDescription {
        private File _fontFile;

        private FileFontDescription(File fontFile, int weight, IdentValue style) {
            super(weight, style);
            this._fontFile = fontFile;
        }

        @Override
        protected boolean realizeFont() {
            if (this._font == null && this._fontFile != null) {
                try {
                    this._font = Font.createFont(0, this._fontFile);
                    this._fontFile = null;
                }
                catch (FontFormatException | IOException e) {
                    XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_JAVA2D_COULD_NOT_LOAD_FONT, (Throwable)e);
                    return false;
                }
            }
            return this._font != null;
        }
    }

    private static class InputStreamFontDescription
    extends FontDescription {
        private FSSupplier<InputStream> _supplier;

        private InputStreamFontDescription(FSSupplier<InputStream> supplier, int weight, IdentValue style) {
            super(weight, style);
            this._supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean realizeFont() {
            if (this._font == null && this._supplier != null) {
                InputStream is = (InputStream)this._supplier.supply();
                this._supplier = null;
                if (is == null) {
                    return false;
                }
                try {
                    this._font = Font.createFont(0, is);
                }
                catch (FontFormatException | IOException e) {
                    XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_JAVA2D_COULD_NOT_LOAD_FONT, (Throwable)e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return this._font != null;
        }
    }

    private static abstract class FontDescription
    implements MinimalFontDescription {
        protected final int _weight;
        protected final IdentValue _style;
        protected Font _font;

        private FontDescription(int weight, IdentValue style) {
            this._weight = weight;
            this._style = style;
        }

        public int getWeight() {
            return this._weight;
        }

        public IdentValue getStyle() {
            return this._style;
        }

        private Font getBaseFont() {
            return this._font;
        }

        protected abstract boolean realizeFont();
    }
}

