/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import org.objectweb.asm.Label;
import org.objectweb.asm.util.DumpClassVisitor;
import org.objectweb.asm.util.PrintCodeVisitor;

public class DumpCodeVisitor
extends PrintCodeVisitor {
    private final HashMap labelNames = new HashMap();

    public void printInsn(int n) {
        this.buf.append("cv.visitInsn(").append(PrintCodeVisitor.OPCODES[n]).append(");\n");
    }

    public void printIntInsn(int n, int n2) {
        this.buf.append("cv.visitIntInsn(").append(PrintCodeVisitor.OPCODES[n]).append(", ").append(n2).append(");\n");
    }

    public void printVarInsn(int n, int n2) {
        this.buf.append("cv.visitVarInsn(").append(PrintCodeVisitor.OPCODES[n]).append(", ").append(n2).append(");\n");
    }

    public void printTypeInsn(int n, String string) {
        this.buf.append("cv.visitTypeInsn(").append(PrintCodeVisitor.OPCODES[n]).append(", ");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(");\n");
    }

    public void printFieldInsn(int n, String string, String string2, String string3) {
        this.buf.append("cv.visitFieldInsn(").append(PrintCodeVisitor.OPCODES[n]).append(", ");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string3);
        this.buf.append(");\n");
    }

    public void printMethodInsn(int n, String string, String string2, String string3) {
        this.buf.append("cv.visitMethodInsn(").append(PrintCodeVisitor.OPCODES[n]).append(", ");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string3);
        this.buf.append(");\n");
    }

    public void printJumpInsn(int n, Label label) {
        this.declareLabel(label);
        this.buf.append("cv.visitJumpInsn(").append(PrintCodeVisitor.OPCODES[n]).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
    }

    public void printLabel(Label label) {
        this.declareLabel(label);
        this.buf.append("cv.visitLabel(");
        this.appendLabel(label);
        this.buf.append(");\n");
    }

    public void printLdcInsn(Object object) {
        this.buf.append("cv.visitLdcInsn(");
        DumpClassVisitor.appendConstant(this.buf, object);
        this.buf.append(");\n");
    }

    public void printIincInsn(int n, int n2) {
        this.buf.append("cv.visitIincInsn(").append(n).append(", ").append(n2).append(");\n");
    }

    public void printTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        int n3 = 0;
        while (n3 < labelArray.length) {
            this.declareLabel(labelArray[n3]);
            ++n3;
        }
        this.declareLabel(label);
        this.buf.append("cv.visitTableSwitchInsn(").append(n).append(", ").append(n2).append(", ");
        this.appendLabel(label);
        this.buf.append(", new Label[] {");
        int n4 = 0;
        while (n4 < labelArray.length) {
            this.buf.append(n4 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n4]);
            ++n4;
        }
        this.buf.append(" });\n");
    }

    public void printLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n = 0;
        while (n < labelArray.length) {
            this.declareLabel(labelArray[n]);
            ++n;
        }
        this.declareLabel(label);
        this.buf.append("cv.visitLookupSwitchInsn(");
        this.appendLabel(label);
        this.buf.append(", new int[] {");
        int n2 = 0;
        while (n2 < nArray.length) {
            this.buf.append(n2 == 0 ? " " : ", ").append(nArray[n2]);
            ++n2;
        }
        this.buf.append(" }, new Label[] {");
        int n3 = 0;
        while (n3 < labelArray.length) {
            this.buf.append(n3 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n3]);
            ++n3;
        }
        this.buf.append(" });\n");
    }

    public void printMultiANewArrayInsn(String string, int n) {
        this.buf.append("cv.visitMultiANewArrayInsn(");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ").append(n).append(");\n");
    }

    public void printTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.append("cv.visitTryCatchBlock(");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ");
        this.appendLabel(label3);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(");\n");
    }

    public void printMaxs(int n, int n2) {
        this.buf.append("cv.visitMaxs(").append(n).append(", ").append(n2).append(");\n");
    }

    public void printLocalVariable(String string, String string2, Label label, Label label2, int n) {
        this.buf.append("cv.visitLocalVariable(");
        DumpClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ").append(n).append(");\n");
    }

    public void printLineNumber(int n, Label label) {
        this.buf.append("cv.visitLineNumber(").append(n).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
    }

    private void declareLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "l" + this.labelNames.size();
            this.labelNames.put(label, string);
            this.buf.append("Label ").append(string).append(" = new Label();\n");
        }
    }

    private void appendLabel(Label label) {
        this.buf.append((String)this.labelNames.get(label));
    }
}

