/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class ClassIntrospector
implements Opcodes {
    public static final int INCLUDE_PUBLIC_FIELDS = 1;
    public static final int INCLUDE_ALL_FIELDS = 2;
    public static final int INCLUDE_PARENT_FIELDS = 4;
    public static final int INCLUDE_PUBLIC_CONSTRUCTORS = 8;
    public static final int INCLUDE_ALL_CONSTRUCTORS = 16;
    public static final int INCLUDE_PARENT_CONSTRUCTORS = 32;
    public static final int INCLUDE_PUBLIC_METHODS = 64;
    public static final int INCLUDE_ALL_METHODS = 128;
    public static final int INCLUDE_PARENT_METHODS = 256;

    public void accept(ClassVisitor classVisitor, Class clazz, int n, int n2) {
        int n3 = clazz.getModifiers();
        n3 |= 0x20;
        n3 &= 0xFFFFFFF7;
        if (clazz.getDeclaringClass() != null || clazz.getEnclosingClass() != null) {
            n3 &= 0xFFFFEFF9;
        }
        String string = Type.getInternalName((Class)clazz);
        Class clazz2 = clazz.getSuperclass();
        String string2 = clazz2 == null ? null : Type.getInternalName(clazz2);
        String[] stringArray = ClassIntrospector.getNames(clazz.getInterfaces());
        classVisitor.visit(n2, n3, string, null, string2, stringArray);
        if ((n & 1 | 2) != 0) {
            this.acceptFields(clazz, classVisitor, n);
        }
        if ((n & 8 | 0x10) != 0) {
            this.acceptConstructors(clazz, classVisitor, n);
        }
        if ((n & 0x40 | 0x80) != 0) {
            this.acceptMethods(clazz, classVisitor, n);
        }
        classVisitor.visitEnd();
    }

    private void acceptFields(Class clazz, ClassVisitor classVisitor, int n) {
        Class clazz2;
        Field[] fieldArray = (n & 1) > 0 ? clazz.getFields() : clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n2 = field.getModifiers();
            String string = field.getName();
            String string2 = Type.getDescriptor(field.getType());
            FieldVisitor fieldVisitor = classVisitor.visitField(n2, string, string2, null, null);
            fieldVisitor.visitEnd();
        }
        if ((n & 4) != 0 && (clazz2 = clazz.getSuperclass()) != null) {
            this.acceptFields(clazz2, classVisitor, n);
        }
    }

    private void acceptConstructors(Class clazz, ClassVisitor classVisitor, int n) {
        Class clazz2;
        Constructor<?>[] constructorArray = (n & 8) > 0 ? clazz.getConstructors() : clazz.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            int n2 = constructor.getModifiers();
            String string = Type.getConstructorDescriptor(constructor);
            String[] stringArray = ClassIntrospector.getNames(constructor.getExceptionTypes());
            MethodVisitor methodVisitor = classVisitor.visitMethod(n2, "<init>", string, null, stringArray);
            methodVisitor.visitEnd();
        }
        if ((n & 0x20) != 0 && (clazz2 = clazz.getSuperclass()) != null) {
            this.acceptConstructors(clazz2, classVisitor, n);
        }
    }

    private void acceptMethods(Class clazz, ClassVisitor classVisitor, int n) {
        Class clazz2;
        Method[] methodArray = (n & 0x40) > 0 ? clazz.getMethods() : clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n2 = method.getModifiers();
            String string = method.getName();
            String string2 = Type.getMethodDescriptor((Method)method);
            String[] stringArray = ClassIntrospector.getNames(method.getExceptionTypes());
            MethodVisitor methodVisitor = classVisitor.visitMethod(n2, string, string2, null, stringArray);
            methodVisitor.visitEnd();
        }
        if ((n & 0x100) != 0 && (clazz2 = clazz.getSuperclass()) != null) {
            this.acceptMethods(clazz2, classVisitor, n);
        }
    }

    private static final String[] getNames(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Type.getInternalName((Class)classArray[i]);
        }
        return stringArray;
    }
}

