/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LocalVariablesSorter
extends MethodAdapter {
    private Map locals = new HashMap();
    protected final int firstLocal;
    private int nextLocal;

    public LocalVariablesSorter(int n, String string, MethodVisitor methodVisitor) {
        super(methodVisitor);
        Type[] typeArray = Type.getArgumentTypes((String)string);
        this.nextLocal = (8 & n) != 0 ? 0 : 1;
        for (int i = 0; i < typeArray.length; ++i) {
            this.nextLocal += typeArray[i].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int n, int n2) {
        int n3;
        switch (n) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                n3 = 2;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        this.mv.visitVarInsn(n, this.remap(n2, n3));
    }

    public void visitIincInsn(int n, int n2) {
        this.mv.visitIincInsn(this.remap(n, 1), n2);
    }

    public void visitMaxs(int n, int n2) {
        this.mv.visitMaxs(0, 0);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.mv.visitLocalVariable(string, string2, string3, label, label2, this.remap(n));
    }

    protected int newLocal(int n) {
        int n2 = this.nextLocal;
        this.nextLocal += n;
        return n2;
    }

    private int remap(int n, int n2) {
        if (n < this.firstLocal) {
            return n;
        }
        Integer n3 = new Integer(n2 == 2 ? ~n : n);
        Integer n4 = (Integer)this.locals.get(n3);
        if (n4 == null) {
            n4 = new Integer(this.newLocal(n2));
            this.locals.put(n3, n4);
        }
        return n4;
    }

    private int remap(int n) {
        if (n < this.firstLocal) {
            return n;
        }
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.locals.get(n2);
        if (n3 == null && (n3 = (Integer)this.locals.get(n2 = new Integer(~n))) == null) {
            throw new IllegalStateException("Unknown local variable " + n);
        }
        return n3;
    }
}

