/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.apt;

import java.io.PrintWriter;
import java.io.Writer;
import javax.lang.model.element.TypeElement;
import org.kohsuke.args4j.apt.AnnotationVisitor;
import org.kohsuke.args4j.apt.OptionWithUsage;

class XmlWriter
implements AnnotationVisitor {
    private final PrintWriter out;

    public XmlWriter(Writer out, TypeElement d) {
        this.out = new PrintWriter(out);
        this.out.println("<usage class='" + d.getQualifiedName() + "'>");
    }

    public void onOption(String name, String usage) {
        this.out.println("  <option>");
        this.writeTag("name", name);
        this.writeTag("usage", usage);
        this.out.println("  </option>");
    }

    public void onOption(OptionWithUsage optionWithUsage) {
        this.out.println("  <option>");
        this.writeTag("name", optionWithUsage.option.name());
        this.writeTag("usage", optionWithUsage.usage);
        this.out.println("  </option>");
    }

    private void writeTag(String tag, String value) {
        this.out.println("    <" + tag + "><![CDATA[" + value + "]]></" + tag + ">");
    }

    public void done() {
        this.out.println("</usage>");
        this.out.close();
    }
}

