/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.apt;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.apt.AnnotationProcessorImpl;
import org.kohsuke.args4j.apt.IsolatingClassLoader;
import org.kohsuke.args4j.apt.Mode;
import org.kohsuke.args4j.apt.ReloadingClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    @Option(name="-o", usage="output directory to place generated HTML/XML")
    private File outDir = new File(".");
    @Option(name="-mode", usage="output format. 'XML' 'TXT' or 'HTML'")
    private Mode mode = Mode.HTML;
    @Option(name="-res", usage="resource file name to obtain usage strings from.\nUsing this option will cause Option.usage() to be used as a key to this resource")
    private String resourceName = null;
    @Option(name="-r")
    private boolean hidden = false;
    @Argument
    private List<String> aptArgs = new ArrayList<String>();

    public static void main(String[] args) throws Exception {
        System.exit(new Main().run(args));
    }

    public int run(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser(this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            this.printUsage(parser);
            return -1;
        }
        if (this.aptArgs.isEmpty()) {
            this.printUsage(parser);
            return 0;
        }
        System.setProperty("args4j.outdir", this.outDir.getPath());
        System.setProperty("args4j.format", this.mode.name());
        if (this.resourceName == null) {
            this.resourceName = "";
        }
        System.setProperty("args4j.resource", this.resourceName);
        this.aptArgs.add(0, "-proc:only");
        this.aptArgs.add(1, "-processor");
        this.aptArgs.add(2, AnnotationProcessorImpl.class.getName());
        JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
        return javac.run(System.in, System.out, System.err, this.aptArgs.toArray(new String[0]));
    }

    private void printUsage(CmdLineParser parser) {
        System.err.println("argsj-tools [options...] sourcefiles...");
        System.err.println("  Generates the list of options in XML/HTML");
        parser.printUsage(System.err);
    }

    private Method getProcessMethod(Class<?> apt) {
        for (Method m : apt.getDeclaredMethods()) {
            Class<?>[] p;
            if (!m.getName().equals("process") || (p = m.getParameterTypes()).length != 2 || p[1] != String[].class || !p[0].getName().endsWith("AnnotationProcessorFactory")) continue;
            return m;
        }
        throw new Error("Unable to find the entry point to APT. Please use the latest version of JDK 5.0");
    }

    public ClassLoader loadToolsJar() {
        File jreHome = new File(System.getProperty("java.home"));
        File toolsJar = new File(jreHome.getParent(), "lib/tools.jar");
        try {
            return new ReloadingClassLoader(new URLClassLoader(new URL[]{toolsJar.toURL()}, (ClassLoader)new IsolatingClassLoader(Main.class.getClassLoader())));
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }
}

