/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LayoutUtils {
    static final Log log = LogFactory.getLog(LayoutUtils.class);

    public static int findVerticalOffset(JRDesignBand band) {
        int finalHeight = 0;
        if (band != null) {
            for (JRChild jrChild : band.getChildren()) {
                JRDesignElement element = (JRDesignElement)jrChild;
                int currentHeight = element.getY() + element.getHeight();
                if (currentHeight <= finalHeight) continue;
                finalHeight = currentHeight;
            }
            return finalHeight;
        }
        return finalHeight;
    }

    public static void copyBandElements(JRDesignBand destBand, JRBand sourceBand) {
        int offset = LayoutUtils.findVerticalOffset(destBand);
        if (destBand == null) {
            throw new DJException("destination band cannot be null");
        }
        if (sourceBand == null) {
            return;
        }
        for (JRChild jrChild : sourceBand.getChildren()) {
            JRDesignElement element = (JRDesignElement)jrChild;
            JRDesignElement dest = null;
            try {
                if (element instanceof JRDesignGraphicElement) {
                    Constructor<?> constructor = element.getClass().getConstructor(JRDefaultStyleProvider.class);
                    JRDesignStyle style = new JRDesignStyle();
                    dest = (JRDesignElement)constructor.newInstance(style.getDefaultStyleProvider());
                } else {
                    dest = (JRDesignElement)element.getClass().newInstance();
                }
                BeanUtils.copyProperties((Object)dest, (Object)element);
                dest.setY(dest.getY() + offset);
            }
            catch (Exception e) {
                log.error((Object)("Exception copying elements from band to band: " + e.getMessage()), (Throwable)e);
            }
            destBand.addElement(dest);
        }
    }

    public static void moveBandsElemnts(int yOffset, JRDesignBand band) {
        if (band == null) {
            return;
        }
        for (JRChild jrChild : band.getChildren()) {
            JRDesignElement elem = (JRDesignElement)jrChild;
            elem.setY(elem.getY() + yOffset);
        }
    }

    public static void registerCustomExpressionParameter(DynamicJasperDesign design, String name, CustomExpression customExpression) {
        if (customExpression == null) {
            return;
        }
        LayoutUtils.registerAndAddParameter(design, name, customExpression.getClass().getName(), customExpression);
    }

    public static void registerAndAddParameter(DynamicJasperDesign design, String name, String classname, Object value) {
        JRDesignParameter dparam = new JRDesignParameter();
        dparam.setName(name);
        dparam.setValueClassName(classname);
        log.debug((Object)("Registering parameter parameter with name: " + name + ", classname: " + classname));
        try {
            design.addParameter((JRParameter)dparam);
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage(), e);
        }
        design.getParametersWithValues().put(name, value);
    }

    public static JRDesignGroup getJRDesignGroup(DynamicJasperDesign jd, LayoutManager layoutManager, DJGroup group) {
        Map<String, Object> references = layoutManager.getReferencesMap();
        for (String o : references.keySet()) {
            String groupName = o;
            DJGroup djGroup = (DJGroup)references.get(groupName);
            if (group != djGroup) continue;
            return (JRDesignGroup)jd.getGroupsMap().get(groupName);
        }
        return null;
    }

    public static JRDesignGroup findParentJRGroup(DJGroup djgroup, DynamicReport dr, DynamicJasperDesign djd, LayoutManager layoutManager) {
        JRDesignGroup registeredGroup;
        int gidx = dr.getColumnsGroups().indexOf(djgroup);
        if (gidx > 0) {
            DJGroup djParentGroup = dr.getColumnsGroups().get(--gidx);
            registeredGroup = LayoutUtils.getJRDesignGroup(djd, layoutManager, djParentGroup);
        } else {
            registeredGroup = null;
        }
        return registeredGroup;
    }

    public static DJGroup findChildDJGroup(DJGroup djgroup, DynamicReport dr) {
        DJGroup child = null;
        int gidx = dr.getColumnsGroups().indexOf(djgroup);
        if (gidx + 1 < dr.getColumnsGroups().size()) {
            child = dr.getColumnsGroups().get(++gidx);
        }
        return child;
    }

    public static JRDesignBand getBandFromSection(JRDesignSection section) {
        return (JRDesignBand)section.getBandsList().get(0);
    }

    public static SplitTypeEnum getSplitTypeFromBoolean(boolean allowsplit) {
        if (allowsplit) {
            return SplitTypeEnum.IMMEDIATE;
        }
        return SplitTypeEnum.PREVENT;
    }

    public static void convertBorderToPen(Border border, JRPen pen) {
        if (border == null) {
            return;
        }
        pen.setLineWidth(Float.valueOf(border.getWidth()));
        pen.setLineStyle(LineStyleEnum.getByValue((byte)border.getLineStyle()));
        pen.setLineColor(border.getColor());
    }
}

