/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.core.layout.LayoutException;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJChart;
import ar.com.fdvs.dj.domain.DJChartOptions;
import ar.com.fdvs.dj.domain.DJWaterMark;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.DataSetFactory;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.DJColSpan;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.BarCodeColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.ImageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PercentageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.HyperLinkUtil;
import ar.com.fdvs.dj.util.LayoutUtils;
import ar.com.fdvs.dj.util.Utils;
import ar.com.fdvs.dj.util.WaterMarkRenderer;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLayoutManager
implements LayoutManager {
    private static final Log log = LogFactory.getLog(AbstractLayoutManager.class);
    protected static final String EXPRESSION_TRUE_WHEN_ODD = "new java.lang.Boolean(((Number)$V{REPORT_COUNT}).doubleValue() % 2 == 0)";
    protected static final String EXPRESSION_TRUE_WHEN_EVEN = "new java.lang.Boolean(((Number)$V{REPORT_COUNT}).doubleValue() % 2 != 0)";
    JasperDesign design;
    private DynamicReport report;
    private Map<String, JRStyle> reportStyles = new HashMap<String, JRStyle>();
    protected final List<JRGroup> realGroups = new ArrayList<JRGroup>();

    protected abstract void transformDetailBandTextField(AbstractColumn var1, JRDesignTextField var2);

    public Map<String, JRStyle> getReportStyles() {
        return this.reportStyles;
    }

    public void setReportStyles(Map<String, JRStyle> reportStyles) {
        this.reportStyles = reportStyles;
    }

    @Override
    public void applyLayout(JasperDesign design, DynamicReport report) throws LayoutException {
        log.debug((Object)"Applying Layout...");
        try {
            this.setDesign(design);
            this.setReport(report);
            this.ensureDJStyles();
            this.startLayout();
            this.applyWaterMark();
            this.transformDetailBand();
            this.endLayout();
            this.setWhenNoDataBand();
            this.setBandsFinalHeight();
            this.registerRemainingStyles();
        }
        catch (RuntimeException e) {
            throw new LayoutException(e.getMessage(), e);
        }
    }

    protected void applyWaterMark() {
        DynamicReport dr = this.getReport();
        JasperDesign jd = this.getDesign();
        DJWaterMark djWaterMark = dr.getWaterMark();
        if (djWaterMark == null || Utils.isEmpty(djWaterMark.getText())) {
            return;
        }
        JRDesignBand backgroundBand = (JRDesignBand)jd.getBackground();
        if (backgroundBand == null) {
            backgroundBand = new JRDesignBand();
            jd.setBackground((JRBand)backgroundBand);
        }
        int printableHeight = jd.getPageHeight() - jd.getTopMargin() - jd.getBottomMargin();
        int printableWidth = jd.getPageWidth() - jd.getLeftMargin() - jd.getRightMargin();
        backgroundBand.setHeight(printableHeight);
        JRDesignImage image = new JRDesignImage(new JRDesignStyle().getDefaultStyleProvider());
        JRDesignExpression imageExp = null;
        int multiplier = 2;
        Font font2 = (Font)djWaterMark.getFont().clone();
        font2.setFontSize(font2.getFontSize() * (float)multiplier);
        BufferedImage watermark = WaterMarkRenderer.rotateText(djWaterMark.getText(), font2.toAwtFont(), printableWidth * multiplier, printableHeight * multiplier, djWaterMark.getAngle(), djWaterMark.getTextColor());
        try {
            File outputFile = File.createTempFile("dynamicJasper", "watermark.png");
            outputFile.deleteOnExit();
            ImageIO.write((RenderedImage)watermark, "png", outputFile);
            String absolutePath = outputFile.getAbsolutePath();
            log.debug((Object)("Watermark Image: " + absolutePath));
            String escapeTextForExpression = Utils.escapeTextForExpression(absolutePath);
            imageExp = ExpressionUtils.createStringExpression("\"" + escapeTextForExpression + "\"");
        }
        catch (IOException e) {
            log.error((Object)("Could not create watermark image: " + e.getMessage()), (Throwable)e);
        }
        image.setExpression(imageExp);
        image.setHeight(printableHeight);
        image.setWidth(printableWidth);
        image.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        image.setOnErrorType(OnErrorTypeEnum.BLANK);
        backgroundBand.addElement((JRDesignElement)image);
    }

    protected void setWhenNoDataBand() {
        log.debug((Object)"setting up WHEN NO DATA band");
        String whenNoDataText = this.getReport().getWhenNoDataText();
        Style style = this.getReport().getWhenNoDataStyle();
        if (whenNoDataText == null || "".equals(whenNoDataText)) {
            return;
        }
        JRDesignBand band = new JRDesignBand();
        this.getDesign().setNoData((JRBand)band);
        JRDesignTextField text = new JRDesignTextField();
        JRDesignExpression expression = ExpressionUtils.createStringExpression("\"" + whenNoDataText + "\"");
        text.setExpression((JRExpression)expression);
        if (style == null) {
            style = this.getReport().getOptions().getDefaultDetailStyle();
        }
        if (this.getReport().isWhenNoDataShowTitle()) {
            LayoutUtils.copyBandElements(band, this.getDesign().getTitle());
            LayoutUtils.copyBandElements(band, this.getDesign().getPageHeader());
        }
        if (this.getReport().isWhenNoDataShowColumnHeader()) {
            LayoutUtils.copyBandElements(band, this.getDesign().getColumnHeader());
        }
        int offset = LayoutUtils.findVerticalOffset(band);
        text.setY(offset);
        this.applyStyleToElement(style, (JRDesignElement)text);
        text.setWidth(this.getReport().getOptions().getPrintableWidth());
        text.setHeight(50);
        band.addElement((JRDesignElement)text);
        log.debug((Object)"OK setting up WHEN NO DATA band");
    }

    protected void startLayout() {
        this.setColumnsFinalWidth();
        this.realGroups.addAll(this.getDesign().getGroupsList());
    }

    protected void endLayout() {
        this.layoutCharts();
        this.setBandsFinalHeight();
    }

    protected void registerRemainingStyles() {
    }

    protected void ensureDJStyles() {
        for (Style style : this.getReport().getStyles().values()) {
            this.addStyleToDesign(style);
        }
        Style defaultDetailStyle = this.getReport().getOptions().getDefaultDetailStyle();
        Style defaultHeaderStyle = this.getReport().getOptions().getDefaultHeaderStyle();
        for (AbstractColumn column : this.report.getColumns()) {
            if (column.getStyle() == null) {
                column.setStyle(defaultDetailStyle);
            }
            if (column.getHeaderStyle() != null) continue;
            column.setHeaderStyle(defaultHeaderStyle);
        }
    }

    public void addStyleToDesign(Style style) {
        JRDesignStyle jrstyle = style.transform();
        if (style.getFont() != null && style.getFont().getPdfFontEncoding() == null && this.getReport().getDefaultEncoding() != null) {
            style.getFont().setPdfFontEncoding(this.getReport().getDefaultEncoding());
        }
        try {
            JRStyle old;
            if (jrstyle.getName() == null) {
                String name = this.createUniqueStyleName();
                jrstyle.setName(name);
                style.setName(name);
                this.getReportStyles().put(name, (JRStyle)jrstyle);
                this.design.addStyle((JRStyle)jrstyle);
            }
            if ((old = (JRStyle)this.design.getStylesMap().get(jrstyle.getName())) != null && style.isOverridesExistingStyle()) {
                log.debug((Object)("Overriding style with name \"" + style.getName() + "\""));
                this.design.removeStyle(style.getName());
                this.design.addStyle((JRStyle)jrstyle);
            } else if (old == null) {
                log.debug((Object)("Registering new style with name \"" + style.getName() + "\""));
                this.design.addStyle((JRStyle)jrstyle);
            } else if (style.getName() != null) {
                log.debug((Object)("Using existing style for style with name \"" + style.getName() + "\""));
            }
        }
        catch (JRException e) {
            log.debug((Object)("Duplicated style (it's ok): " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUniqueStyleName() {
        AbstractLayoutManager abstractLayoutManager = this;
        synchronized (abstractLayoutManager) {
            int counter = this.getReportStyles().values().size() + 1;
            String tryName = "dj_style_" + counter + "_";
            while (this.design.getStylesMap().get(tryName) != null) {
                tryName = "dj_style_" + ++counter;
            }
            return tryName;
        }
    }

    protected void transformDetailBand() {
        JRDesignBand detail;
        log.debug((Object)"transforming Detail Band...");
        JRDesignSection detailSection = (JRDesignSection)this.design.getDetailSection();
        if (detailSection.getBandsList().isEmpty()) {
            detail = new JRDesignBand();
            detailSection.getBandsList().add(detail);
        } else {
            detail = (JRDesignBand)detailSection.getBandsList().iterator().next();
        }
        detail.setHeight(this.report.getOptions().getDetailHeight());
        for (AbstractColumn column : this.getVisibleColumns()) {
            JRDesignExpression imageExp;
            JRDesignImage image;
            if (column instanceof BarCodeColumn) {
                BarCodeColumn barcodeColumn = (BarCodeColumn)column;
                image = new JRDesignImage(new JRDesignStyle().getDefaultStyleProvider());
                imageExp = new JRDesignExpression();
                String applicationIdentifier = barcodeColumn.getApplicationIdentifier();
                applicationIdentifier = applicationIdentifier != null && !"".equals(applicationIdentifier.trim()) ? "$F{" + applicationIdentifier + "}" : "\"\"";
                imageExp.setText("ar.com.fdvs.dj.core.BarcodeHelper.getBarcodeImage(" + barcodeColumn.getBarcodeType() + ", " + column.getTextForExpression() + ", " + barcodeColumn.isShowText() + ", " + barcodeColumn.isCheckSum() + ", " + applicationIdentifier + ",0,0 )");
                imageExp.setValueClass(Image.class);
                image.setExpression((JRExpression)imageExp);
                image.setHeight(this.getReport().getOptions().getDetailHeight());
                image.setWidth(column.getWidth());
                image.setX(column.getPosX());
                image.setScaleImage(ScaleImageEnum.getByValue((byte)barcodeColumn.getScaleMode().getValue()));
                image.setOnErrorType(OnErrorTypeEnum.ICON);
                if (column.getLink() != null) {
                    String name = "column_" + this.getReport().getColumns().indexOf(column);
                    HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.getDesign(), column.getLink(), image, name);
                }
                this.applyStyleToElement(column.getStyle(), (JRDesignElement)image);
                detail.addElement((JRDesignElement)image);
                continue;
            }
            if (column instanceof ImageColumn) {
                ImageColumn imageColumn = (ImageColumn)column;
                image = new JRDesignImage(new JRDesignStyle().getDefaultStyleProvider());
                imageExp = new JRDesignExpression();
                imageExp.setText(column.getTextForExpression());
                imageExp.setValueClassName(imageColumn.getValueClassNameForExpression());
                image.setExpression((JRExpression)imageExp);
                image.setHeight(this.getReport().getOptions().getDetailHeight());
                image.setWidth(column.getWidth());
                image.setX(column.getPosX());
                image.setScaleImage(ScaleImageEnum.getByValue((byte)imageColumn.getScaleMode().getValue()));
                this.applyStyleToElement(column.getStyle(), (JRDesignElement)image);
                if (column.getLink() != null) {
                    String name = "column_" + this.getReport().getColumns().indexOf(column);
                    HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.getDesign(), column.getLink(), image, name);
                }
                detail.addElement((JRDesignElement)image);
                continue;
            }
            if (!this.getReport().getOptions().isShowDetailBand()) continue;
            JRDesignTextField textField = this.generateTextFieldFromColumn(column, this.getReport().getOptions().getDetailHeight(), null);
            if (column.getLink() != null) {
                String name = this.getDesign().getName() + "_column_" + this.getReport().getColumns().indexOf(column);
                HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.getDesign(), column.getLink(), textField, name);
            }
            this.transformDetailBandTextField(column, textField);
            if (textField.getExpression() == null) continue;
            detail.addElement((JRDesignElement)textField);
        }
    }

    protected void generateHeaderBand(JRDesignBand band) {
        log.debug((Object)"Adding column names in header band.");
        band.setHeight(this.report.getOptions().getHeaderHeight());
        for (AbstractColumn col : this.getVisibleColumns()) {
            if (col.getTitle() == null) continue;
            Style headerStyle = col.getHeaderStyle();
            if (headerStyle == null) {
                headerStyle = this.report.getOptions().getDefaultHeaderStyle();
            }
            this.generateColspanHeader(col, band);
            JRDesignExpression expression = new JRDesignExpression();
            JRDesignTextField textField = new JRDesignTextField();
            expression.setText("\"" + col.getTitle() + "\"");
            if (col.getHeaderMarkup() != null) {
                textField.setMarkup(col.getHeaderMarkup().toLowerCase());
            }
            expression.setValueClass(String.class);
            textField.setKey("header_" + col.getTitle());
            textField.setExpression((JRExpression)expression);
            if (col.hasParentCol()) {
                textField.setY(col.getPosY() + band.getHeight() / 2);
                textField.setHeight(band.getHeight() / 2);
            } else {
                textField.setY(col.getPosY());
                textField.setHeight(band.getHeight());
            }
            textField.setX(col.getPosX());
            textField.setWidth(col.getWidth());
            textField.setPrintWhenDetailOverflows(true);
            textField.setBlankWhenNull(true);
            this.applyStyleToElement(headerStyle, (JRDesignElement)textField);
            band.addElement((JRDesignElement)textField);
        }
    }

    private void generateColspanHeader(AbstractColumn col, JRDesignBand band) {
        DJColSpan colSpan = col.getColSpan();
        if (colSpan != null && colSpan.isFirstColum(col)) {
            JRDesignTextField spanTitle = new JRDesignTextField();
            JRDesignExpression colspanExpression = new JRDesignExpression();
            colspanExpression.setValueClassName(String.class.getName());
            colspanExpression.setText("\"" + col.getColSpan().getTitle() + "\"");
            spanTitle.setExpression((JRExpression)colspanExpression);
            spanTitle.setKey("colspan-header" + col.getTitle());
            spanTitle.setX(col.getPosX());
            spanTitle.setY(col.getPosY());
            spanTitle.setHeight(band.getHeight() / 2);
            spanTitle.setWidth(colSpan.getWidth());
            Style spanStyle = colSpan.getColspanHeaderStyle();
            if (spanStyle == null) {
                spanStyle = this.report.getOptions().getDefaultHeaderStyle();
            }
            this.applyStyleToElement(spanStyle, (JRDesignElement)spanTitle);
            band.addElement((JRDesignElement)spanTitle);
        }
    }

    public void applyStyleToElement(Style style, JRDesignElement designElemen) {
        JRDesignTextElement textField;
        JRDesignStyle jrstyle;
        boolean existsInDesign;
        if (style == null) {
            JRDesignStyle style_ = new JRDesignStyle();
            style_.setName(this.createUniqueStyleName());
            designElemen.setStyle((JRStyle)style_);
            try {
                this.getDesign().addStyle((JRStyle)style_);
            }
            catch (JRException jRException) {
                // empty catch block
            }
            return;
        }
        boolean bl = existsInDesign = style.getName() != null && this.design.getStylesMap().get(style.getName()) != null;
        if (existsInDesign && !style.isOverridesExistingStyle()) {
            jrstyle = (JRDesignStyle)this.design.getStylesMap().get(style.getName());
        } else {
            this.addStyleToDesign(style);
            jrstyle = style.transform();
        }
        designElemen.setStyle((JRStyle)jrstyle);
        if (designElemen instanceof JRDesignTextElement) {
            textField = (JRDesignTextElement)designElemen;
            if (style.getStreching() != null) {
                textField.setStretchType(StretchTypeEnum.getByValue((byte)style.getStreching().getValue()));
            }
            textField.setPositionType(PositionTypeEnum.FLOAT);
        }
        if (designElemen instanceof JRDesignTextField) {
            textField = (JRDesignTextField)designElemen;
            textField.setStretchWithOverflow(style.isStretchWithOverflow());
            if (!textField.isBlankWhenNull() && style.isBlankWhenNull()) {
                textField.setBlankWhenNull(true);
            }
        }
        if (designElemen instanceof JRDesignGraphicElement) {
            JRDesignGraphicElement graphicElement = (JRDesignGraphicElement)designElemen;
            graphicElement.setStretchType(StretchTypeEnum.getByValue((byte)style.getStreching().getValue()));
            graphicElement.setPositionType(PositionTypeEnum.FLOAT);
        }
    }

    protected void setColumnsFinalWidth() {
        log.debug((Object)"Setting columns final width.");
        int printableArea = this.report.getOptions().getColumnWidth();
        List<AbstractColumn> visibleColums = this.getVisibleColumns();
        if (this.report.getOptions().isUseFullPageWidth()) {
            int columnsWidth = 0;
            int notRezisableWidth = 0;
            Iterator<AbstractColumn> i$ = visibleColums.iterator();
            while (i$.hasNext()) {
                AbstractColumn visibleColum;
                AbstractColumn col = visibleColum = i$.next();
                columnsWidth += col.getWidth();
                if (!col.isFixedWidth()) continue;
                notRezisableWidth += col.getWidth();
            }
            float factor = (float)(printableArea - notRezisableWidth) / (float)(columnsWidth - notRezisableWidth);
            log.debug((Object)("printableArea = " + printableArea + ", columnsWidth = " + columnsWidth + ", columnsWidth = " + columnsWidth + ", notRezisableWidth = " + notRezisableWidth + ", factor = " + factor));
            int acumulated = 0;
            Collection resizableColumns = CollectionUtils.select(visibleColums, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return !((AbstractColumn)arg0).isFixedWidth();
                }
            });
            Iterator iter = resizableColumns.iterator();
            while (iter.hasNext()) {
                AbstractColumn col = (AbstractColumn)iter.next();
                if (!iter.hasNext()) {
                    col.setWidth(printableArea - notRezisableWidth - acumulated);
                    continue;
                }
                int colFinalWidth = new Float((float)col.getWidth() * factor).intValue();
                acumulated += colFinalWidth;
                col.setWidth(colFinalWidth);
            }
        }
        int posx = 0;
        Iterator<AbstractColumn> i$ = visibleColums.iterator();
        while (i$.hasNext()) {
            AbstractColumn visibleColum;
            AbstractColumn col = visibleColum = i$.next();
            col.setPosX(posx);
            posx += col.getWidth();
        }
    }

    protected List<AbstractColumn> getVisibleColumns() {
        return new ArrayList<AbstractColumn>(this.report.getColumns());
    }

    protected void setBandsFinalHeight() {
        log.debug((Object)"Setting bands final height...");
        ArrayList bands = new ArrayList();
        Utils.addNotNull(bands, this.design.getPageHeader());
        Utils.addNotNull(bands, this.design.getPageFooter());
        Utils.addNotNull(bands, this.design.getColumnHeader());
        Utils.addNotNull(bands, this.design.getColumnFooter());
        Utils.addNotNull(bands, this.design.getSummary());
        Utils.addNotNull(bands, this.design.getBackground());
        bands.addAll(((JRDesignSection)this.design.getDetailSection()).getBandsList());
        Utils.addNotNull(bands, this.design.getLastPageFooter());
        Utils.addNotNull(bands, this.design.getTitle());
        Utils.addNotNull(bands, this.design.getPageFooter());
        Utils.addNotNull(bands, this.design.getNoData());
        for (JRGroup jrgroup : this.design.getGroupsList()) {
            DJGroup djGroup = (DJGroup)this.getReferencesMap().get(jrgroup.getName());
            JRDesignSection headerSection = (JRDesignSection)jrgroup.getGroupHeaderSection();
            JRDesignSection footerSection = (JRDesignSection)jrgroup.getGroupFooterSection();
            if (djGroup != null) {
                for (JRBand headerBand : headerSection.getBandsList()) {
                    this.setBandFinalHeight((JRDesignBand)headerBand, djGroup.getHeaderHeight(), djGroup.isFitHeaderHeightToContent());
                }
                for (JRBand footerBand : footerSection.getBandsList()) {
                    this.setBandFinalHeight((JRDesignBand)footerBand, djGroup.getFooterHeight(), djGroup.isFitFooterHeightToContent());
                }
                continue;
            }
            bands.addAll(headerSection.getBandsList());
            bands.addAll(footerSection.getBandsList());
        }
        for (JRBand jrDesignBand : bands) {
            this.setBandFinalHeight((JRDesignBand)jrDesignBand);
        }
    }

    private void setBandFinalHeight(JRDesignBand band, int currHeigth, boolean fitToContent) {
        int finalHeight;
        if (band != null && ((finalHeight = LayoutUtils.findVerticalOffset(band)) >= currHeigth || fitToContent)) {
            band.setHeight(finalHeight);
        }
    }

    protected void setBandFinalHeight(JRDesignBand band) {
        if (band != null) {
            int finalHeight = LayoutUtils.findVerticalOffset(band);
            band.setHeight(finalHeight);
        }
    }

    protected JRDesignTextField generateTextFieldFromColumn(AbstractColumn col, int height, DJGroup group) {
        JRDesignTextField textField = new JRDesignTextField();
        JRDesignExpression exp = new JRDesignExpression();
        if (col.getPattern() != null && "".equals(col.getPattern().trim())) {
            textField.setPattern(col.getPattern());
        }
        if (col.getTruncateSuffix() != null) {
            textField.getPropertiesMap().setProperty("net.sf.jasperreports.text.truncate.suffix", col.getTruncateSuffix());
        }
        List<DJGroup> columnsGroups = this.getReport().getColumnsGroups();
        if (col instanceof PercentageColumn) {
            PercentageColumn pcol = (PercentageColumn)col;
            if (group == null) {
                DJGroup innerMostGroup = columnsGroups.get(columnsGroups.size() - 1);
                exp.setText(pcol.getTextForExpression(innerMostGroup));
            } else {
                exp.setText(pcol.getTextForExpression(group));
            }
            textField.setEvaluationTime(EvaluationTimeEnum.AUTO);
        } else {
            exp.setText(col.getTextForExpression());
        }
        exp.setValueClassName(col.getValueClassNameForExpression());
        textField.setExpression((JRExpression)exp);
        textField.setWidth(col.getWidth());
        textField.setX(col.getPosX());
        textField.setY(col.getPosY());
        textField.setHeight(height);
        textField.setBlankWhenNull(col.isBlankWhenNull());
        textField.setPattern(col.getPattern());
        if (col.getMarkup() != null) {
            textField.setMarkup(col.getMarkup().toLowerCase());
        }
        textField.setPrintRepeatedValues(col.isPrintRepeatedValues());
        textField.setPrintWhenDetailOverflows(true);
        Style columnStyle = col.getStyle();
        if (columnStyle == null) {
            columnStyle = this.report.getOptions().getDefaultDetailStyle();
        }
        this.applyStyleToElement(columnStyle, (JRDesignElement)textField);
        JRDesignStyle jrstyle = (JRDesignStyle)textField.getStyle();
        if (group != null) {
            int index = columnsGroups.indexOf(group);
            JRDesignGroup previousGroup = this.getJRGroupFromDJGroup(group);
            textField.setPrintWhenGroupChanges((JRGroup)previousGroup);
            JRDesignStyle groupStyle = Utils.cloneStyle(jrstyle);
            groupStyle.setName(groupStyle.getFontName() + "_for_group_" + index + "_");
            textField.setStyle((JRStyle)groupStyle);
            try {
                this.design.addStyle((JRStyle)groupStyle);
            }
            catch (JRException jRException) {}
        } else {
            JRDesignStyle alternateStyle = Utils.cloneStyle(jrstyle);
            alternateStyle.setName(alternateStyle.getFontName() + "_for_column_" + col.getName() + "_");
            alternateStyle.getConditionalStyleList().clear();
            textField.setStyle((JRStyle)alternateStyle);
            try {
                this.design.addStyle((JRStyle)alternateStyle);
            }
            catch (JRException jRException) {
                // empty catch block
            }
            this.setUpConditionStyles(alternateStyle, col);
        }
        return textField;
    }

    private void setUpConditionStyles(JRDesignStyle jrstyle, AbstractColumn column) {
        if (this.getReport().getOptions().isPrintBackgroundOnOddRows() && Utils.isEmpty(column.getConditionalStyles())) {
            JRDesignExpression expression = new JRDesignExpression();
            expression.setValueClass(Boolean.class);
            expression.setText(EXPRESSION_TRUE_WHEN_ODD);
            Style oddRowBackgroundStyle = this.getReport().getOptions().getOddRowBackgroundStyle();
            JRDesignConditionalStyle condStyle = new JRDesignConditionalStyle();
            condStyle.setBackcolor(oddRowBackgroundStyle.getBackgroundColor());
            condStyle.setMode(ModeEnum.OPAQUE);
            condStyle.setConditionExpression((JRExpression)expression);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyle);
            return;
        }
        if (Utils.isEmpty(column.getConditionalStyles())) {
            return;
        }
        for (ConditionalStyle condition : column.getConditionalStyles()) {
            if (this.getReport().getOptions().isPrintBackgroundOnOddRows() && Transparency.TRANSPARENT == condition.getStyle().getTransparency()) {
                JRDesignExpression expressionForConditionalStyle = ExpressionUtils.getExpressionForConditionalStyle(condition, column.getTextForExpression());
                String expStr = JRExpressionUtil.getExpressionText((JRExpression)expressionForConditionalStyle);
                JRDesignExpression expressionOdd = new JRDesignExpression();
                expressionOdd.setValueClass(Boolean.class);
                expressionOdd.setText("new java.lang.Boolean(new java.lang.Boolean(((Number)$V{REPORT_COUNT}).doubleValue() % 2 == 0).booleanValue() && ((java.lang.Boolean)" + expStr + ").booleanValue() )");
                Style oddRowBackgroundStyle = this.getReport().getOptions().getOddRowBackgroundStyle();
                JRDesignConditionalStyle condStyleOdd = this.makeConditionalStyle(condition.getStyle());
                condStyleOdd.setBackcolor(oddRowBackgroundStyle.getBackgroundColor());
                condStyleOdd.setMode(ModeEnum.OPAQUE);
                condStyleOdd.setConditionExpression((JRExpression)expressionOdd);
                jrstyle.addConditionalStyle((JRConditionalStyle)condStyleOdd);
                JRDesignExpression expressionEven = new JRDesignExpression();
                expressionEven.setValueClass(Boolean.class);
                expressionEven.setText("new java.lang.Boolean(new java.lang.Boolean(((Number)$V{REPORT_COUNT}).doubleValue() % 2 != 0).booleanValue() && ((java.lang.Boolean)" + expStr + ").booleanValue() )");
                JRDesignConditionalStyle condStyleEven = this.makeConditionalStyle(condition.getStyle());
                condStyleEven.setConditionExpression((JRExpression)expressionEven);
                jrstyle.addConditionalStyle((JRConditionalStyle)condStyleEven);
                continue;
            }
            JRDesignExpression expression = ExpressionUtils.getExpressionForConditionalStyle(condition, column.getTextForExpression());
            JRDesignConditionalStyle condStyle = this.makeConditionalStyle(condition.getStyle());
            condStyle.setConditionExpression((JRExpression)expression);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyle);
        }
        if (this.getReport().getOptions().isPrintBackgroundOnOddRows()) {
            JRDesignExpression expressionOdd = new JRDesignExpression();
            expressionOdd.setValueClass(Boolean.class);
            expressionOdd.setText(EXPRESSION_TRUE_WHEN_ODD);
            Style oddRowBackgroundStyle = this.getReport().getOptions().getOddRowBackgroundStyle();
            JRDesignConditionalStyle condStyleOdd = new JRDesignConditionalStyle();
            condStyleOdd.setBackcolor(oddRowBackgroundStyle.getBackgroundColor());
            condStyleOdd.setMode(ModeEnum.OPAQUE);
            condStyleOdd.setConditionExpression((JRExpression)expressionOdd);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyleOdd);
            JRDesignExpression expressionEven = new JRDesignExpression();
            expressionEven.setValueClass(Boolean.class);
            expressionEven.setText(EXPRESSION_TRUE_WHEN_EVEN);
            JRDesignConditionalStyle condStyleEven = new JRDesignConditionalStyle();
            condStyleEven.setBackcolor(jrstyle.getBackcolor());
            condStyleEven.setMode(jrstyle.getModeValue());
            condStyleEven.setConditionExpression((JRExpression)expressionEven);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyleEven);
        }
    }

    protected JRDesignConditionalStyle makeConditionalStyle(Style style) {
        return style.transformAsConditinalStyle();
    }

    protected void layoutCharts() {
        ArrayListValuedHashMap mmap = new ArrayListValuedHashMap();
        for (DJChart djChart : this.getReport().getCharts()) {
            mmap.put((Object)djChart.getColumnsGroup(), (Object)djChart);
        }
        for (DJGroup key : mmap.keySet()) {
            Collection charts = mmap.get((Object)key);
            ArrayList l = new ArrayList(charts);
            for (int i = l.size(); i > 0; --i) {
                DJChart djChart = (DJChart)l.get(i - 1);
                JRDesignChart chart = this.createChart(djChart);
                JRDesignBand band = this.createGroupForChartAndGetBand(djChart);
                band.addElement((JRDesignElement)chart);
            }
        }
        ArrayListValuedHashMap mmap2 = new ArrayListValuedHashMap();
        for (ar.com.fdvs.dj.domain.chart.DJChart djChart : this.getReport().getNewCharts()) {
            mmap2.put((Object)djChart.getDataset().getColumnsGroup(), (Object)djChart);
        }
        for (PropertyColumn key : mmap2.keySet()) {
            Collection charts = mmap2.get((Object)key);
            ArrayList l = new ArrayList(charts);
            for (int i = l.size(); i > 0; --i) {
                ar.com.fdvs.dj.domain.chart.DJChart djChart = (ar.com.fdvs.dj.domain.chart.DJChart)l.get(i - 1);
                String name = "chart_" + (i - 1) + new Date().getTime();
                JRDesignChart chart = this.createChart(djChart, name);
                if (djChart.getLink() != null) {
                    HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.getDesign(), djChart.getLink(), chart, name + "_hyperlink");
                }
                JRDesignBand band = this.createGroupForChartAndGetBand(djChart);
                band.addElement((JRDesignElement)chart);
            }
        }
    }

    protected JRDesignBand createGroupForChartAndGetBand(DJChart djChart) {
        JRDesignGroup jrGroupChart;
        JRDesignGroup jrGroup = this.getJRGroupFromDJGroup(djChart.getColumnsGroup());
        JRDesignGroup parentGroup = this.getParent(jrGroup);
        try {
            jrGroupChart = new JRDesignGroup();
            jrGroupChart.setExpression(parentGroup.getExpression());
            ((JRDesignSection)jrGroupChart.getGroupFooterSection()).addBand((JRBand)new JRDesignBand());
            ((JRDesignSection)jrGroupChart.getGroupHeaderSection()).addBand((JRBand)new JRDesignBand());
            jrGroupChart.setName(jrGroupChart.getName() + "_Chart" + this.getReport().getCharts().indexOf(djChart));
        }
        catch (Exception e) {
            throw new DJException("Problem creating band for chart: " + e.getMessage(), e);
        }
        if (jrGroup.equals(parentGroup)) {
            jrGroupChart.setExpression((JRExpression)ExpressionUtils.createStringExpression("\"dummy_for_chart\""));
            this.getDesign().getGroupsList().add(this.getDesign().getGroupsList().indexOf(jrGroup), jrGroupChart);
        } else {
            int index = this.getDesign().getGroupsList().indexOf(parentGroup);
            this.getDesign().getGroupsList().add(index, jrGroupChart);
        }
        JRDesignBand band = null;
        switch (djChart.getOptions().getPosition()) {
            case 2: {
                band = (JRDesignBand)((JRDesignSection)jrGroupChart.getGroupHeaderSection()).getBandsList().get(0);
                break;
            }
            case 1: {
                band = (JRDesignBand)((JRDesignSection)jrGroupChart.getGroupFooterSection()).getBandsList().get(0);
            }
        }
        return band;
    }

    protected JRDesignChart createChart(DJChart djChart) {
        JRDesignGroup jrGroupChart = this.getJRGroupFromDJGroup(djChart.getColumnsGroup());
        JRDesignChart chart = new JRDesignChart(new JRDesignStyle().getDefaultStyleProvider(), djChart.getType());
        JRDesignGroup parentGroup = this.getParent(jrGroupChart);
        List<JRDesignVariable> chartVariables = this.registerChartVariable(djChart);
        JRDesignChartDataset chartDataset = DataSetFactory.getDataset(djChart, jrGroupChart, parentGroup, chartVariables);
        chart.setDataset((JRChartDataset)chartDataset);
        this.interpeterOptions(djChart, chart);
        chart.setEvaluationTime(EvaluationTimeEnum.GROUP);
        chart.setEvaluationGroup((JRGroup)jrGroupChart);
        return chart;
    }

    protected void interpeterOptions(DJChart djChart, JRDesignChart chart) {
        DJChartOptions options = djChart.getOptions();
        if (options.isCentered()) {
            chart.setWidth(this.getReport().getOptions().getPrintableWidth());
        } else {
            chart.setWidth(options.getWidth());
        }
        chart.setHeight(options.getHeight());
        chart.setX(options.getX());
        chart.setY(options.getY());
        chart.setShowLegend(Boolean.valueOf(options.isShowLegend()));
        chart.setBackcolor(options.getBackColor());
        if (options.getColors() != null) {
            int i = 1;
            for (Color color : options.getColors()) {
                chart.getPlot().getSeriesColors().add(new JRBaseChartPlot.JRBaseSeriesColor(i, color));
                ++i;
            }
        }
        if (djChart.getType() == 3) {
            ((JRDesignBarPlot)chart.getPlot()).setShowTickLabels(Boolean.valueOf(options.isShowLabels()));
        }
    }

    protected List<JRDesignVariable> registerChartVariable(DJChart chart) {
        JRDesignGroup group = this.getJRGroupFromDJGroup(chart.getColumnsGroup());
        ArrayList<JRDesignVariable> vars = new ArrayList<JRDesignVariable>();
        int serieNum = 0;
        Iterator<AbstractColumn> i$ = chart.getColumns().iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            AbstractColumn o;
            AbstractColumn col = o = i$.next();
            JRDesignExpression expression = new JRDesignExpression();
            if (col instanceof ExpressionColumn) {
                try {
                    clazz = Class.forName(((ExpressionColumn)col).getExpression().getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new DJException("Exeption creating chart variable: " + e.getMessage(), e);
                }
                ExpressionColumn expCol = (ExpressionColumn)col;
                expression.setText(expCol.getTextForExpression());
                expression.setValueClassName(expCol.getExpression().getClassName());
            } else {
                try {
                    clazz = Class.forName(((PropertyColumn)col).getColumnProperty().getValueClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new DJException("Exeption creating chart variable: " + e.getMessage(), e);
                }
                expression.setText("$F{" + ((PropertyColumn)col).getColumnProperty().getProperty() + "}");
                expression.setValueClass(clazz);
            }
            JRDesignVariable var = new JRDesignVariable();
            var.setValueClass(clazz);
            var.setExpression((JRExpression)expression);
            var.setCalculation(CalculationEnum.getByValue((byte)chart.getOperation()));
            var.setResetGroup((JRGroup)group);
            var.setResetType(ResetTypeEnum.GROUP);
            int chartIndex = this.getReport().getCharts().indexOf(chart);
            var.setName("CHART_[" + chartIndex + "_s" + serieNum + "+]_" + group.getName() + "_" + col.getTitle() + "_" + chart.getOperation());
            try {
                this.getDesign().addVariable(var);
                vars.add(var);
            }
            catch (JRException e) {
                throw new LayoutException(e.getMessage(), e);
            }
            ++serieNum;
        }
        return vars;
    }

    protected JRDesignGroup getChartColumnsGroup(ar.com.fdvs.dj.domain.chart.DJChart djChart) {
        PropertyColumn columnsGroup = djChart.getDataset().getColumnsGroup();
        for (DJGroup djGroup : this.getReport().getColumnsGroups()) {
            if (djGroup.getColumnToGroupBy() != columnsGroup) continue;
            return this.getJRGroupFromDJGroup(djGroup);
        }
        return null;
    }

    protected JRDesignBand createGroupForChartAndGetBand(ar.com.fdvs.dj.domain.chart.DJChart djChart) {
        JRDesignGroup jrGroupChart;
        JRDesignGroup jrGroup = this.getChartColumnsGroup(djChart);
        JRDesignGroup parentGroup = this.getParent(jrGroup);
        try {
            jrGroupChart = new JRDesignGroup();
            jrGroupChart.setExpression(parentGroup.getExpression());
            ((JRDesignSection)jrGroupChart.getGroupFooterSection()).addBand((JRBand)new JRDesignBand());
            ((JRDesignSection)jrGroupChart.getGroupHeaderSection()).addBand((JRBand)new JRDesignBand());
            jrGroupChart.setName(jrGroupChart.getName() + "_Chart" + this.getReport().getCharts().indexOf(djChart));
        }
        catch (Exception e) {
            throw new DJException("Problem creating band for chart: " + e.getMessage(), e);
        }
        if (jrGroup.equals(parentGroup)) {
            jrGroupChart.setExpression((JRExpression)ExpressionUtils.createStringExpression("\"dummy_for_chart\""));
            this.getDesign().getGroupsList().add(this.getDesign().getGroupsList().indexOf(jrGroup), jrGroupChart);
        } else {
            int index = this.getDesign().getGroupsList().indexOf(parentGroup);
            this.getDesign().getGroupsList().add(index, jrGroupChart);
        }
        JRDesignBand band = null;
        switch (djChart.getOptions().getPosition()) {
            case 2: {
                band = (JRDesignBand)((JRDesignSection)jrGroupChart.getGroupHeaderSection()).getBandsList().get(0);
                break;
            }
            case 1: {
                band = (JRDesignBand)((JRDesignSection)jrGroupChart.getGroupFooterSection()).getBandsList().get(0);
            }
        }
        return band;
    }

    protected JRDesignChart createChart(ar.com.fdvs.dj.domain.chart.DJChart djChart, String name) {
        JRDesignGroup jrGroupChart = this.getChartColumnsGroup(djChart);
        JRDesignGroup parentGroup = this.getParent(jrGroupChart);
        Map<AbstractColumn, JRDesignVariable> chartVariables = this.registerChartVariable(djChart);
        return djChart.transform((DynamicJasperDesign)this.getDesign(), name, jrGroupChart, parentGroup, chartVariables, this.getReport().getOptions().getPrintableWidth());
    }

    protected Map<AbstractColumn, JRDesignVariable> registerChartVariable(ar.com.fdvs.dj.domain.chart.DJChart chart) {
        JRDesignGroup group = this.getChartColumnsGroup(chart);
        HashMap<AbstractColumn, JRDesignVariable> vars = new HashMap<AbstractColumn, JRDesignVariable>();
        int serieNum = 0;
        for (Object o : chart.getDataset().getColumns()) {
            Class<?> clazz;
            AbstractColumn col = (AbstractColumn)o;
            JRDesignExpression expression = new JRDesignExpression();
            if (col instanceof ExpressionColumn) {
                try {
                    clazz = Class.forName(((ExpressionColumn)col).getExpression().getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new DJException("Exeption creating chart variable: " + e.getMessage(), e);
                }
                ExpressionColumn expCol = (ExpressionColumn)col;
                expression.setText(expCol.getTextForExpression());
                expression.setValueClassName(expCol.getExpression().getClassName());
            } else {
                try {
                    clazz = Class.forName(((PropertyColumn)col).getColumnProperty().getValueClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new DJException("Exeption creating chart variable: " + e.getMessage(), e);
                }
                expression.setText("$F{" + ((PropertyColumn)col).getColumnProperty().getProperty() + "}");
                expression.setValueClass(clazz);
            }
            JRDesignVariable var = new JRDesignVariable();
            var.setValueClass(clazz);
            var.setExpression((JRExpression)expression);
            var.setCalculation(CalculationEnum.getByValue((byte)chart.getOperation()));
            var.setResetGroup((JRGroup)group);
            var.setResetType(ResetTypeEnum.GROUP);
            int chartIndex = this.getReport().getNewCharts().indexOf(chart);
            var.setName("CHART_[" + chartIndex + "_s" + serieNum + "+]_" + group.getName() + "_" + col.getTitle() + "_" + chart.getOperation());
            try {
                this.getDesign().addVariable(var);
                vars.put(col, var);
            }
            catch (JRException e) {
                throw new LayoutException(e.getMessage(), e);
            }
            ++serieNum;
        }
        return vars;
    }

    protected JRDesignGroup getParent(JRDesignGroup group) {
        int index = this.realGroups.indexOf(group);
        return index > 0 ? (JRDesignGroup)this.realGroups.get(index - 1) : group;
    }

    protected JRDesignGroup getJRGroupFromDJGroup(DJGroup group) {
        int index = this.getReport().getColumnsGroups().indexOf(group);
        return (JRDesignGroup)this.realGroups.get(index);
    }

    protected DJGroup getDJGroup(AbstractColumn col) {
        for (DJGroup group : this.getReport().getColumnsGroups()) {
            if (!group.getColumnToGroupBy().equals(col)) continue;
            return group;
        }
        return null;
    }

    protected JasperDesign getDesign() {
        return this.design;
    }

    protected void setDesign(JasperDesign design) {
        this.design = design;
    }

    protected DynamicReport getReport() {
        return this.report;
    }

    protected void setReport(DynamicReport report) {
        this.report = report;
    }
}

