/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.registration;

import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.AbstractEntityRegistrationManager;
import ar.com.fdvs.dj.core.registration.ColumnsGroupVariablesRegistrationManager;
import ar.com.fdvs.dj.core.registration.DJCrosstabRegistrationManager;
import ar.com.fdvs.dj.core.registration.DJGroupVariableDefRegistrationManager;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.Entity;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.GlobalGroupColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.util.ExpressionUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.CalculationEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJGroupRegistrationManager
extends AbstractEntityRegistrationManager {
    private static final Log log = LogFactory.getLog(DJGroupRegistrationManager.class);

    public DJGroupRegistrationManager(DynamicJasperDesign jd, DynamicReport dr, LayoutManager layoutManager) {
        super(jd, dr, layoutManager);
    }

    protected void registerEntity(Entity entity) {
        DJGroup djgroup = (DJGroup)entity;
        try {
            if (djgroup.getName() == null) {
                PropertyColumn column = djgroup.getColumnToGroupBy();
                String prefix = this.getDjd().getName() + "_";
                int groupIndex = this.getDynamicReport().getColumnsGroups().indexOf(djgroup);
                int columnIndex = this.getDynamicReport().getColumns().indexOf(djgroup.getColumnToGroupBy());
                if (column instanceof GlobalGroupColumn) {
                    djgroup.setName(prefix + "global_column_" + groupIndex);
                } else {
                    djgroup.setName(prefix + "group[" + groupIndex + "]_for_column_" + columnIndex + "-" + column.getName());
                }
            }
            log.debug((Object)("registering group " + djgroup.getName()));
            JRDesignGroup group = (JRDesignGroup)this.transformEntity(djgroup);
            this.getDjd().addGroup(group);
            String property = djgroup.getColumnToGroupBy().getColumnProperty().getProperty();
            if (djgroup.getFooterLabel() != null && djgroup.getFooterLabel().getLabelExpression() != null) {
                this.registerCustomExpressionParameter(group.getName() + "_labelExpression", djgroup.getFooterLabel().getLabelExpression());
            }
            DJGroupVariableDefRegistrationManager variablesRM = new DJGroupVariableDefRegistrationManager(this.getDjd(), this.getDynamicReport(), this.getLayoutManager(), group);
            variablesRM.registerEntities(djgroup.getVariables());
            ColumnsGroupVariablesRegistrationManager headerVariablesRM = new ColumnsGroupVariablesRegistrationManager("header", property, this.getDjd(), this.getDynamicReport(), this.getLayoutManager());
            headerVariablesRM.registerEntities(djgroup.getHeaderVariables());
            ColumnsGroupVariablesRegistrationManager footerVariablesRM = new ColumnsGroupVariablesRegistrationManager("footer", property, this.getDjd(), this.getDynamicReport(), this.getLayoutManager());
            footerVariablesRM.registerEntities(djgroup.getFooterVariables());
            DJCrosstabRegistrationManager headerCrosstabsRm = new DJCrosstabRegistrationManager("header", this.getDjd(), this.getDynamicReport(), this.getLayoutManager());
            headerCrosstabsRm.registerEntities(djgroup.getHeaderCrosstabs());
            DJCrosstabRegistrationManager footerCrosstabsRm = new DJCrosstabRegistrationManager("footer", this.getDjd(), this.getDynamicReport(), this.getLayoutManager());
            footerCrosstabsRm.registerEntities(djgroup.getFooterCrosstabs());
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage(), e);
        }
    }

    protected Object transformEntity(Entity entity) throws JRException {
        DJGroup djgroup = (DJGroup)entity;
        PropertyColumn column = djgroup.getColumnToGroupBy();
        JRDesignGroup group = new JRDesignGroup();
        group.setName(djgroup.getName());
        this.getLayoutManager().getReferencesMap().put(group.getName(), djgroup);
        group.setCountVariable((JRVariable)new JRDesignVariable());
        JRDesignSection gfs = (JRDesignSection)group.getGroupFooterSection();
        gfs.getBandsList().add(new JRDesignBand());
        JRDesignSection ghs = (JRDesignSection)group.getGroupHeaderSection();
        ghs.getBandsList().add(new JRDesignBand());
        JRDesignExpression jrExpression = new JRDesignExpression();
        CustomExpression expressionToGroupBy = column.getExpressionToGroupBy();
        if (expressionToGroupBy != null) {
            this.useVariableForCustomExpression(group, jrExpression, expressionToGroupBy);
        } else if (column instanceof ExpressionColumn) {
            ExpressionColumn col = (ExpressionColumn)column;
            CustomExpression customExpression = col.getExpression();
            this.useVariableForCustomExpression(group, jrExpression, customExpression);
        } else {
            jrExpression.setText(column.getTextForExpression());
            jrExpression.setValueClassName(column.getValueClassNameForExpression());
        }
        group.setExpression((JRExpression)jrExpression);
        return group;
    }

    protected void useVariableForCustomExpression(JRDesignGroup group, JRDesignExpression jrExpression, CustomExpression customExpression) throws JRException {
        String expToGroupByName = group.getName() + "_custom_expression";
        this.registerCustomExpressionParameter(expToGroupByName, customExpression);
        JRDesignVariable gvar = new JRDesignVariable();
        String varName = group.getName() + "_variable_for_group_expression";
        gvar.setName(varName);
        gvar.setCalculation(CalculationEnum.NOTHING);
        gvar.setValueClassName(customExpression.getClassName());
        String expText = ExpressionUtils.createCustomExpressionInvocationText(customExpression, expToGroupByName);
        JRDesignExpression gvarExp = new JRDesignExpression();
        gvarExp.setValueClassName(customExpression.getClassName());
        gvarExp.setText(expText);
        gvar.setExpression((JRExpression)gvarExp);
        this.getDjd().addVariable(gvar);
        jrExpression.setText("$V{" + varName + "}");
        jrExpression.setValueClassName(customExpression.getClassName());
        log.debug((Object)("Expression for CustomExpression usgin variable = \"" + varName + "\" which point to: " + expText));
    }
}

