/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.entities;

import ar.com.fdvs.dj.core.DJDefaultScriptlet;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.entities.Entity;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJGroupVariable
implements Entity {
    private static final Log log = LogFactory.getLog((Class)DJGroupVariable.class);
    private AbstractColumn columnToApplyOperation;
    private DJCalculation operation;
    private Style style;
    private DJValueFormatter valueFormatter;
    private DJGroupLabel label;

    public DJGroupVariable(AbstractColumn columnToApplyOperation, DJCalculation operation) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.operation = operation;
    }

    public DJGroupVariable(AbstractColumn columnToApplyOperation, DJCalculation operation, Style style) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.operation = operation;
        this.style = style;
    }

    public DJGroupVariable(AbstractColumn columnToApplyOperation, DJCalculation operation, Style style, DJValueFormatter formatter) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.operation = operation;
        this.style = style;
        this.valueFormatter = formatter;
    }

    public String getTextForValueFormatterExpression(String variableName) {
        String fieldsMap = DJDefaultScriptlet.class.getName() + ".getCurrentFiels()";
        String parametersMap = DJDefaultScriptlet.class.getName() + ".getCurrentParams()";
        String variablesMap = DJDefaultScriptlet.class.getName() + ".getCurrentVariables()";
        String stringExpression = "(((" + DJValueFormatter.class.getName() + ")$P{" + variableName + "_vf}).evaluate( " + "$V{" + variableName + "}, " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " ))";
        log.debug((Object)("Expression for DJValueFormatter = " + stringExpression));
        return stringExpression;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public AbstractColumn getColumnToApplyOperation() {
        return this.columnToApplyOperation;
    }

    public void setColumnToApplyOperation(AbstractColumn columnToApplyOperation) {
        this.columnToApplyOperation = columnToApplyOperation;
    }

    public DJCalculation getOperation() {
        return this.operation;
    }

    public void setOperation(DJCalculation operation) {
        this.operation = operation;
    }

    public DJValueFormatter getValueFormatter() {
        return this.valueFormatter;
    }

    public void setValueFormatter(DJValueFormatter valueFormatter) {
        this.valueFormatter = valueFormatter;
    }

    public DJGroupLabel getLabel() {
        return this.label;
    }

    public void setLabel(DJGroupLabel label) {
        this.label = label;
    }

    public static Log getLog() {
        return log;
    }

    public DJGroupVariable(AbstractColumn columnToApplyOperation, DJCalculation operation, Style style, DJValueFormatter valueFormatter, DJGroupLabel label) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.operation = operation;
        this.style = style;
        this.valueFormatter = valueFormatter;
        this.label = label;
    }
}

