/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.spring.boot.autoconfigure;

import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.impl.io.jaxb.SolverConfigIO;
import ai.timefold.solver.spring.boot.autoconfigure.config.SolverManagerProperties;
import ai.timefold.solver.spring.boot.autoconfigure.config.TimefoldProperties;
import java.io.Reader;
import java.io.StringReader;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class TimefoldSolverAotFactory
implements EnvironmentAware {
    private TimefoldProperties timefoldProperties;

    public void setEnvironment(Environment environment) {
        BindResult result = Binder.get((Environment)environment).bind("timefold", TimefoldProperties.class);
        this.timefoldProperties = (TimefoldProperties)result.orElseGet(TimefoldProperties::new);
    }

    public <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> solverManagerSupplier(String solverConfigXml) {
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)this.solverConfigSupplier(solverConfigXml));
        SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
        SolverManagerProperties solverManagerProperties = this.timefoldProperties.getSolverManager();
        if (solverManagerProperties != null && solverManagerProperties.getParallelSolverCount() != null) {
            solverManagerConfig.setParallelSolverCount(solverManagerProperties.getParallelSolverCount());
        }
        return SolverManager.create((SolverFactory)solverFactory, (SolverManagerConfig)solverManagerConfig);
    }

    public SolverConfig solverConfigSupplier(String solverConfigXml) {
        SolverConfigIO solverConfigIO = new SolverConfigIO();
        return solverConfigIO.read((Reader)new StringReader(solverConfigXml));
    }
}

