/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.migration.v8;

import ai.timefold.solver.migration.AbstractRecipe;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ScoreManagerMethodsRecipe
extends AbstractRecipe {
    private static final MatcherMeta[] MATCHER_METAS = new MatcherMeta[]{new MatcherMeta("getSummary(..)"), new MatcherMeta("explainScore(..)"), new MatcherMeta("updateScore(..)")};

    public String getDisplayName() {
        return "ScoreManager: explain(), update()";
    }

    public String getDescription() {
        return "Use `explain()` and `update()` instead of `explainScore()`, `updateScore()` and `getSummary()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor[] visitors = (TreeVisitor[])Arrays.stream(MATCHER_METAS).map(m -> new UsesMethod(m.methodMatcher)).toArray(TreeVisitor[]::new);
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])visitors), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public Expression visitExpression(Expression expression, ExecutionContext ctx) {
                Expression e = super.visitExpression(expression, (Object)ctx);
                MatcherMeta matcherMeta = Arrays.stream(MATCHER_METAS).filter(m -> m.methodMatcher.matches(e)).findFirst().orElse(null);
                if (matcherMeta == null) {
                    return e;
                }
                J.MethodInvocation mi = (J.MethodInvocation)e;
                Expression select = mi.getSelect();
                List arguments = mi.getArguments();
                String pattern = "#{any(" + matcherMeta.classFqn + ")}." + (matcherMeta.methodName.contains("Summary") ? "explain(#{any()}, SolutionUpdatePolicy.UPDATE_SCORE_ONLY).getSummary()" : matcherMeta.methodName.replace(")", ", SolutionUpdatePolicy.UPDATE_SCORE_ONLY)").replace("..", "#{any()}").replace("Score(", "("));
                this.maybeAddImport("ai.timefold.solver.core.api.solver.SolutionUpdatePolicy");
                return (Expression)JavaTemplate.builder((String)pattern).javaParser(AbstractRecipe.JAVA_PARSER).imports(new String[]{"ai.timefold.solver.core.api.solver.SolutionUpdatePolicy"}).build().apply(this.getCursor(), e.getCoordinates().replace(), new Object[]{select, arguments.get(0)});
            }
        });
    }

    private static final class MatcherMeta {
        public final String classFqn;
        public final MethodMatcher methodMatcher;
        public final String methodName;

        public MatcherMeta(String method) {
            this.classFqn = "ai.timefold.solver.core.api.score.ScoreManager";
            this.methodMatcher = new MethodMatcher(this.classFqn + " " + method);
            this.methodName = method;
        }
    }
}

