/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.migration.v8;

import ai.timefold.solver.migration.AbstractRecipe;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class RemoveConstraintPackageRecipe
extends AbstractRecipe {
    public String getDisplayName() {
        return "Constraint Streams: don't use package name in the asConstraint() method";
    }

    public String getDescription() {
        return "Remove the use of constraint package from `asConstraint(package, name)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(new MethodMatcher("ai.timefold.solver.core.api.score.stream.ConstraintBuilder asConstraint(String, String)"))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Expression select = method.getSelect();
                List arguments = method.getArguments();
                String templateCode = "#{any(ai.timefold.solver.core.api.score.stream.ConstraintBuilder)}\n.asConstraint(\"#{}\")";
                JavaTemplate template = JavaTemplate.builder((String)templateCode).javaParser(AbstractRecipe.JAVA_PARSER).build();
                return (J.MethodInvocation)template.apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{select, RemoveConstraintPackageRecipe.this.mergeExpressions((Expression)arguments.get(0), (Expression)arguments.get(1))});
            }
        });
    }

    private String mergeExpressions(Expression constraintPackage, Expression constraintName) {
        return constraintPackage.toString() + "." + constraintName.toString();
    }
}

