/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.subsingle.pickedmovetypestepscore;

import ai.timefold.solver.benchmark.config.statistic.SingleStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.PureSubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.StatisticRegistry;
import ai.timefold.solver.benchmark.impl.statistic.subsingle.pickedmovetypestepscore.PickedMoveTypeStepScoreDiffStatisticPoint;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.List;

public class PickedMoveTypeStepScoreDiffSubSingleStatistic<Solution_>
extends PureSubSingleStatistic<Solution_, PickedMoveTypeStepScoreDiffStatisticPoint, LineChart<Long, Double>> {
    private PickedMoveTypeStepScoreDiffSubSingleStatistic() {
    }

    public PickedMoveTypeStepScoreDiffSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, SingleStatisticType.PICKED_MOVE_TYPE_STEP_SCORE_DIFF);
    }

    @Override
    public void open(StatisticRegistry<Solution_> registry, Tags runTag) {
        registry.addListener(SolverMetric.PICKED_MOVE_TYPE_STEP_SCORE_DIFF, (timeMillisSpent, stepScope) -> {
            if (stepScope instanceof LocalSearchStepScope) {
                String moveType = ((LocalSearchStepScope)stepScope).getStep().describe();
                registry.extractScoreFromMeters(SolverMetric.PICKED_MOVE_TYPE_STEP_SCORE_DIFF, runTag.and(new Tag[]{Tag.of((String)"move.type", (String)moveType)}), score -> this.pointList.add(new PickedMoveTypeStepScoreDiffStatisticPoint((long)timeMillisSpent, moveType, score.raw())));
            }
        });
    }

    @Override
    protected String getCsvHeader() {
        return PickedMoveTypeStepScoreDiffStatisticPoint.buildCsvLine("timeMillisSpent", "moveType", "stepScoreDiff");
    }

    @Override
    protected PickedMoveTypeStepScoreDiffStatisticPoint createPointFromCsvLine(ScoreDefinition<?> scoreDefinition, List<String> csvLine) {
        return new PickedMoveTypeStepScoreDiffStatisticPoint(Long.parseLong(csvLine.get(0)), csvLine.get(1), scoreDefinition.parseScore(csvLine.get(2)));
    }

    @Override
    protected List<LineChart<Long, Double>> generateCharts(BenchmarkReport benchmarkReport) {
        ArrayList builderList = new ArrayList(15);
        for (PickedMoveTypeStepScoreDiffStatisticPoint point : this.getPointList()) {
            long timeMillisSpent = point.getTimeMillisSpent();
            String moveType = point.getMoveType();
            double[] levelValues = point.getStepScoreDiff().toLevelDoubles();
            for (int i = 0; i < levelValues.length && i < 15; ++i) {
                if (i >= builderList.size()) {
                    builderList.add(new LineChart.Builder());
                }
                LineChart.Builder builder = (LineChart.Builder)builderList.get(i);
                builder.add(moveType, timeMillisSpent, levelValues[i]);
            }
        }
        ArrayList<LineChart<Long, Double>> chartList = new ArrayList<LineChart<Long, Double>>(builderList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < builderList.size(); ++scoreLevelIndex) {
            String scoreLevelLabel = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().findScoreLevelLabel(scoreLevelIndex);
            LineChart.Builder builder = (LineChart.Builder)builderList.get(scoreLevelIndex);
            LineChart chart = builder.build("pickedMoveTypeStepScoreDiffSubSingleStatisticChart" + scoreLevelIndex, this.subSingleBenchmarkResult.getName() + " picked move type step " + scoreLevelLabel + " diff statistic", "Time spent", "Step " + scoreLevelLabel + " diff", true, true, false);
            chartList.add(chart);
        }
        return chartList;
    }
}

