/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.result;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.ranking.ScoreSubSingleBenchmarkRankingComparator;
import ai.timefold.solver.benchmark.impl.ranking.SubSingleBenchmarkRankBasedComparator;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.ReportHelper;
import ai.timefold.solver.benchmark.impl.result.BenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.ScoreDifferencePercentage;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.StatisticUtils;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.util.ConfigUtils;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class SingleBenchmarkResult
implements BenchmarkResult {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(1L);
    @XmlID
    @XmlAttribute
    private String id = String.valueOf(ID_GENERATOR.getAndIncrement());
    @XmlTransient
    private SolverBenchmarkResult solverBenchmarkResult;
    @XmlTransient
    private ProblemBenchmarkResult problemBenchmarkResult;
    @XmlElement(name="subSingleBenchmarkResult")
    private List<SubSingleBenchmarkResult> subSingleBenchmarkResultList = null;
    private Long usedMemoryAfterInputSolution = null;
    private Integer failureCount = null;
    private Score totalScore = null;
    private Score averageScore = null;
    private boolean allScoresInitialized = false;
    private SubSingleBenchmarkResult median = null;
    private SubSingleBenchmarkResult best = null;
    private SubSingleBenchmarkResult worst = null;
    private double[] standardDeviationDoubles = null;
    private long timeMillisSpent = -1L;
    private long scoreCalculationCount = -1L;
    private long moveEvaluationCount = -1L;
    private String scoreExplanationSummary = null;
    private Score<?> winningScoreDifference = null;
    private ScoreDifferencePercentage worstScoreDifferencePercentage = null;
    private Double worstScoreCalculationSpeedDifferencePercentage = null;
    private Integer ranking = null;

    public SingleBenchmarkResult() {
    }

    public SingleBenchmarkResult(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult) {
        this.solverBenchmarkResult = solverBenchmarkResult;
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public void initSubSingleStatisticMaps() {
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : this.subSingleBenchmarkResultList) {
            subSingleBenchmarkResult.initSubSingleStatisticMap();
        }
    }

    public SolverBenchmarkResult getSolverBenchmarkResult() {
        return this.solverBenchmarkResult;
    }

    public void setSolverBenchmarkResult(SolverBenchmarkResult solverBenchmarkResult) {
        this.solverBenchmarkResult = solverBenchmarkResult;
    }

    public ProblemBenchmarkResult getProblemBenchmarkResult() {
        return this.problemBenchmarkResult;
    }

    public void setProblemBenchmarkResult(ProblemBenchmarkResult problemBenchmarkResult) {
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public List<SubSingleBenchmarkResult> getSubSingleBenchmarkResultList() {
        return this.subSingleBenchmarkResultList;
    }

    public void setSubSingleBenchmarkResultList(List<SubSingleBenchmarkResult> subSingleBenchmarkResultList) {
        this.subSingleBenchmarkResultList = subSingleBenchmarkResultList;
    }

    public Long getUsedMemoryAfterInputSolution() {
        return this.usedMemoryAfterInputSolution;
    }

    public void setUsedMemoryAfterInputSolution(Long usedMemoryAfterInputSolution) {
        this.usedMemoryAfterInputSolution = usedMemoryAfterInputSolution;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(Integer failureCount) {
        this.failureCount = failureCount;
    }

    public long getTimeMillisSpent() {
        return this.timeMillisSpent;
    }

    public void setTimeMillisSpent(long timeMillisSpent) {
        this.timeMillisSpent = timeMillisSpent;
    }

    public long getScoreCalculationCount() {
        return this.scoreCalculationCount;
    }

    public void setScoreCalculationCount(long scoreCalculationCount) {
        this.scoreCalculationCount = scoreCalculationCount;
    }

    public long getMoveEvaluationCount() {
        return this.moveEvaluationCount;
    }

    public void setMoveEvaluationCount(long moveEvaluationCount) {
        this.moveEvaluationCount = moveEvaluationCount;
    }

    public String getScoreExplanationSummary() {
        return this.scoreExplanationSummary;
    }

    public Score<?> getWinningScoreDifference() {
        return this.winningScoreDifference;
    }

    public void setWinningScoreDifference(Score<?> winningScoreDifference) {
        this.winningScoreDifference = winningScoreDifference;
    }

    public ScoreDifferencePercentage getWorstScoreDifferencePercentage() {
        return this.worstScoreDifferencePercentage;
    }

    public void setWorstScoreDifferencePercentage(ScoreDifferencePercentage worstScoreDifferencePercentage) {
        this.worstScoreDifferencePercentage = worstScoreDifferencePercentage;
    }

    public Double getWorstScoreCalculationSpeedDifferencePercentage() {
        return this.worstScoreCalculationSpeedDifferencePercentage;
    }

    public void setWorstScoreCalculationSpeedDifferencePercentage(Double worstScoreCalculationSpeedDifferencePercentage) {
        this.worstScoreCalculationSpeedDifferencePercentage = worstScoreCalculationSpeedDifferencePercentage;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    @Override
    public Score getAverageScore() {
        return this.averageScore;
    }

    public void setAverageAndTotalScoreForTesting(Score<?> averageAndTotalScore, boolean allScoresInitialized) {
        this.averageScore = averageAndTotalScore;
        this.totalScore = averageAndTotalScore;
        this.allScoresInitialized = allScoresInitialized;
    }

    public SubSingleBenchmarkResult getMedian() {
        return this.median;
    }

    public SubSingleBenchmarkResult getBest() {
        return this.best;
    }

    public SubSingleBenchmarkResult getWorst() {
        return this.worst;
    }

    public Score<?> getTotalScore() {
        return this.totalScore;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.getName());
    }

    @Override
    public String getName() {
        return this.problemBenchmarkResult.getName() + "_" + this.solverBenchmarkResult.getName();
    }

    @Override
    public boolean hasAllSuccess() {
        return this.failureCount != null && this.failureCount == 0;
    }

    public boolean isInitialized() {
        return this.averageScore != null && this.allScoresInitialized;
    }

    @Override
    public boolean hasAnyFailure() {
        return this.failureCount != null && this.failureCount != 0;
    }

    public boolean isScoreFeasible() {
        return this.averageScore.isFeasible();
    }

    public Long getScoreCalculationSpeed() {
        long scoreCalculationCountByThousand = this.scoreCalculationCount * 1000L;
        return this.timeMillisSpent == 0L ? scoreCalculationCountByThousand : scoreCalculationCountByThousand / this.timeMillisSpent;
    }

    public Long getMoveEvaluationSpeed() {
        long moveEvaluationCountByThousand = this.moveEvaluationCount * 1000L;
        return this.timeMillisSpent == 0L ? moveEvaluationCountByThousand : moveEvaluationCountByThousand / this.timeMillisSpent;
    }

    public boolean isWinner() {
        return this.ranking != null && this.ranking == 0;
    }

    public SubSingleStatistic getSubSingleStatistic(ProblemStatisticType problemStatisticType) {
        return this.getMedian().getEffectiveSubSingleStatisticMap().get(problemStatisticType);
    }

    public int getSuccessCount() {
        return this.subSingleBenchmarkResultList.size() - this.failureCount;
    }

    public String getStandardDeviationString() {
        return StatisticUtils.getStandardDeviationString(this.standardDeviationDoubles);
    }

    @Override
    public String getResultDirectoryName() {
        return this.solverBenchmarkResult.getName();
    }

    @Override
    public File getResultDirectory() {
        return new File(this.problemBenchmarkResult.getProblemReportDirectory(), this.getResultDirectoryName());
    }

    public void makeDirs() {
        File singleReportDirectory = this.getResultDirectory();
        singleReportDirectory.mkdirs();
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : this.subSingleBenchmarkResultList) {
            subSingleBenchmarkResult.makeDirs();
        }
    }

    public int getSubSingleCount() {
        return this.subSingleBenchmarkResultList.size();
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : this.subSingleBenchmarkResultList) {
            subSingleBenchmarkResult.accumulateResults(benchmarkReport);
        }
        this.determineTotalsAndAveragesAndRanking();
        this.standardDeviationDoubles = StatisticUtils.determineStandardDeviationDoubles(this.subSingleBenchmarkResultList, this.averageScore, this.getSuccessCount());
        this.determineRepresentativeSubSingleBenchmarkResult();
    }

    private void determineRepresentativeSubSingleBenchmarkResult() {
        if (this.subSingleBenchmarkResultList == null || this.subSingleBenchmarkResultList.isEmpty()) {
            throw new IllegalStateException("Cannot get representative subSingleBenchmarkResult from empty subSingleBenchmarkResultList.");
        }
        ArrayList<SubSingleBenchmarkResult> subSingleBenchmarkResultListCopy = new ArrayList<SubSingleBenchmarkResult>(this.subSingleBenchmarkResultList);
        subSingleBenchmarkResultListCopy.sort(new SubSingleBenchmarkRankBasedComparator());
        this.best = subSingleBenchmarkResultListCopy.get(0);
        this.worst = subSingleBenchmarkResultListCopy.get(subSingleBenchmarkResultListCopy.size() - 1);
        this.median = subSingleBenchmarkResultListCopy.get(ConfigUtils.ceilDivide((int)(subSingleBenchmarkResultListCopy.size() - 1), (int)2));
        this.usedMemoryAfterInputSolution = this.median.getUsedMemoryAfterInputSolution();
        this.timeMillisSpent = this.median.getTimeMillisSpent();
        this.scoreCalculationCount = this.median.getScoreCalculationCount();
        this.moveEvaluationCount = this.median.getMoveEvaluationCount();
        this.scoreExplanationSummary = this.median.getScoreExplanationSummary();
    }

    private void determineTotalsAndAveragesAndRanking() {
        this.failureCount = 0;
        boolean firstNonFailure = true;
        this.totalScore = null;
        ArrayList<SubSingleBenchmarkResult> successResultList = new ArrayList<SubSingleBenchmarkResult>(this.subSingleBenchmarkResultList);
        Iterator<SubSingleBenchmarkResult> it = successResultList.iterator();
        while (it.hasNext()) {
            SubSingleBenchmarkResult subSingleBenchmarkResult = it.next();
            if (subSingleBenchmarkResult.hasAnyFailure()) {
                Integer n = this.failureCount;
                this.failureCount = this.failureCount + 1;
                it.remove();
                continue;
            }
            boolean isInitialized = subSingleBenchmarkResult.isInitialized();
            if (firstNonFailure) {
                this.totalScore = subSingleBenchmarkResult.getAverageScore();
                this.allScoresInitialized = isInitialized;
                firstNonFailure = false;
                continue;
            }
            this.totalScore = this.totalScore.add(subSingleBenchmarkResult.getAverageScore());
            this.allScoresInitialized = this.allScoresInitialized || isInitialized;
        }
        if (!firstNonFailure) {
            this.averageScore = this.totalScore.divide((double)this.getSuccessCount());
        }
        SingleBenchmarkResult.determineRanking(successResultList);
    }

    private static void determineRanking(List<SubSingleBenchmarkResult> rankedSubSingleBenchmarkResultList) {
        ScoreSubSingleBenchmarkRankingComparator subSingleBenchmarkRankingComparator = new ScoreSubSingleBenchmarkRankingComparator();
        rankedSubSingleBenchmarkResultList.sort(Collections.reverseOrder(subSingleBenchmarkRankingComparator));
        int ranking = 0;
        SubSingleBenchmarkResult previousSubSingleBenchmarkResult = null;
        int previousSameRankingCount = 0;
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : rankedSubSingleBenchmarkResultList) {
            if (previousSubSingleBenchmarkResult != null && subSingleBenchmarkRankingComparator.compare(previousSubSingleBenchmarkResult, subSingleBenchmarkResult) != 0) {
                ranking += previousSameRankingCount;
                previousSameRankingCount = 0;
            }
            subSingleBenchmarkResult.setRanking(ranking);
            previousSubSingleBenchmarkResult = subSingleBenchmarkResult;
            ++previousSameRankingCount;
        }
    }

    protected static SingleBenchmarkResult createMerge(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult, SingleBenchmarkResult oldResult) {
        SingleBenchmarkResult newResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        newResult.subSingleBenchmarkResultList = new ArrayList<SubSingleBenchmarkResult>(oldResult.getSubSingleBenchmarkResultList().size());
        int subSingleBenchmarkIndex = 0;
        for (SubSingleBenchmarkResult oldSubResult : oldResult.subSingleBenchmarkResultList) {
            SubSingleBenchmarkResult.createMerge(newResult, oldSubResult, subSingleBenchmarkIndex);
            ++subSingleBenchmarkIndex;
        }
        newResult.median = oldResult.median;
        newResult.best = oldResult.best;
        newResult.worst = oldResult.worst;
        solverBenchmarkResult.getSingleBenchmarkResultList().add(newResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(newResult);
        return newResult;
    }

    public String toString() {
        return this.getName();
    }
}

