/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.report;

import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.Chart;
import ai.timefold.solver.benchmark.impl.report.Dataset;
import ai.timefold.solver.core.impl.util.Pair;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.IntStream;

public record LineChart<X extends Number, Y extends Number>(String id, String title, String xLabel, String yLabel, List<X> keys, List<Dataset<Y>> datasets, boolean stepped, boolean timeOnX, boolean timeOnY) implements Chart
{
    public LineChart(String id, String title, String xLabel, String yLabel, List<X> keys, List<Dataset<Y>> datasets, boolean stepped, boolean timeOnX, boolean timeOnY) {
        this.id = id = Chart.makeIdUnique(id);
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.keys = keys;
        this.datasets = datasets;
        this.stepped = stepped;
        this.timeOnX = timeOnX;
        this.timeOnY = timeOnY;
    }

    public BigDecimal xMin() {
        return LineChart.min(this.keys);
    }

    static <Number_ extends Number> BigDecimal min(List<Number_> values) {
        if (values.isEmpty()) {
            return BigDecimal.ZERO;
        }
        double min = ((Number)Collections.min(values)).doubleValue();
        if (min > 0.0) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(min);
    }

    public BigDecimal xMax() {
        return LineChart.max(this.keys);
    }

    static <Number_ extends Number> BigDecimal max(List<Number_> values) {
        if (values.isEmpty()) {
            return BigDecimal.ZERO;
        }
        double max = ((Number)Collections.max(values)).doubleValue();
        if (max < 0.0) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(max);
    }

    public BigDecimal yMin() {
        return LineChart.min(this.getYValues());
    }

    private List<Y> getYValues() {
        return this.datasets.stream().flatMap(d -> d.data().stream()).filter(x$0 -> Objects.nonNull(x$0)).toList();
    }

    public BigDecimal yMax() {
        return LineChart.max(this.getYValues());
    }

    public BigDecimal xStepSize() {
        return LineChart.stepSize(this.xMin(), this.xMax());
    }

    public BigDecimal yStepSize() {
        return LineChart.stepSize(this.yMin(), this.yMax());
    }

    public boolean xLogarithmic() {
        if (this.timeOnX) {
            return false;
        }
        return LineChart.useLogarithmicProblemScale(this.keys);
    }

    public boolean yLogarithmic() {
        if (this.timeOnY) {
            return false;
        }
        return LineChart.useLogarithmicProblemScale(this.getYValues());
    }

    public List<Pair<X, Y>> points(String label) {
        Dataset dataset = this.datasets().stream().filter(d -> d.label().equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("Dataset %s not found.".formatted(label)));
        return IntStream.range(0, dataset.data().size()).filter(i -> dataset.data().get(i) != null).mapToObj(i -> new Pair((Object)((Number)this.keys().get(i)), (Object)((Number)dataset.data().get(i)))).toList();
    }

    static <N extends Number> boolean useLogarithmicProblemScale(List<N> seriesList) {
        TreeSet<Double> valueSet = new TreeSet<Double>();
        for (Number dataItem : seriesList) {
            double value = dataItem.doubleValue();
            if (value <= 0.0) {
                return false;
            }
            valueSet.add(value);
        }
        if (valueSet.size() < 5) {
            return false;
        }
        double threshold = 0.2 * ((Double)valueSet.last() - (Double)valueSet.first());
        int belowThresholdCount = valueSet.headSet(threshold).size();
        return (double)belowThresholdCount >= 0.6 * (double)valueSet.size();
    }

    static BigDecimal stepSize(BigDecimal min, BigDecimal max) {
        BigDecimal diff = max.subtract(min).abs();
        if (diff.signum() == 0) {
            return BigDecimal.ONE;
        }
        int nearestPowerOfTen = (int)Math.round(Math.log10(diff.doubleValue()));
        return BigDecimal.TEN.pow(nearestPowerOfTen - 2, MathContext.DECIMAL64);
    }

    @Override
    public void writeToFile(Path parentFolder) {
        File file = new File(parentFolder.toFile(), this.id() + ".js");
        file.getParentFile().mkdirs();
        Configuration freeMarkerCfg = BenchmarkReport.createFreeMarkerConfiguration();
        freeMarkerCfg.setClassForTemplateLoading(this.getClass(), "");
        String templateFilename = "chart-line.js.ftl";
        HashMap<String, LineChart> model = new HashMap<String, LineChart>();
        model.put("chart", this);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            Template template = freeMarkerCfg.getTemplate(templateFilename);
            template.process(model, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read templateFilename (" + templateFilename + ") or write chart file (" + String.valueOf(file) + ").", e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("Can not process Freemarker templateFilename (" + templateFilename + ") to chart file (" + this.id + ").", e);
        }
    }

    public static final class Builder<X extends Number, Y extends Number> {
        private static final int MAX_CHART_WIDTH = 3840;
        private final Map<String, NavigableMap<X, Y>> data = new LinkedHashMap<String, NavigableMap<X, Y>>();
        private final Set<String> favoriteSet = new HashSet<String>();

        public Builder<X, Y> add(String dataset, X x, Y y) {
            this.data.computeIfAbsent(dataset, k -> new TreeMap()).put(x, y);
            return this;
        }

        public Set<String> keys() {
            return this.data.keySet();
        }

        public int count(String dataset) {
            return this.data.getOrDefault(dataset, Collections.emptyNavigableMap()).size();
        }

        public Y getLastValue(String dataset) {
            return (Y)((Number)this.data.getOrDefault(dataset, Collections.emptyNavigableMap()).lastEntry().getValue());
        }

        public Builder<X, Y> markFavorite(String dataset) {
            this.favoriteSet.add(dataset);
            return this;
        }

        public LineChart<X, Y> build(String fileName, String title, String xLabel, String yLabel, boolean stepped, boolean timeOnX, boolean timeOnY) {
            this.data.values().forEach(map -> {
                List entries = map.entrySet().stream().toList();
                if (entries.size() < 3) {
                    return;
                }
                for (int i = 0; i < entries.size() - 2; ++i) {
                    Map.Entry entry1 = (Map.Entry)entries.get(i);
                    Map.Entry entry2 = (Map.Entry)entries.get(i + 1);
                    if (!((Number)entry1.getValue()).equals(entry2.getValue())) continue;
                    Map.Entry entry3 = (Map.Entry)entries.get(i + 2);
                    if (!((Number)entry2.getValue()).equals(entry3.getValue())) continue;
                    map.remove(entry2.getKey());
                }
            });
            LinkedHashMap<String, Map<X, Y>> datasetMap = new LinkedHashMap<String, Map<X, Y>>(this.data.size());
            for (Map.Entry<String, NavigableMap<X, Y>> entry : this.data.entrySet()) {
                datasetMap.put(entry.getKey(), this.largestTriangleThreeBuckets(entry.getValue(), 3840));
            }
            List xValues = this.data.values().stream().flatMap(k -> k.keySet().stream()).distinct().sorted((rec$, x$0) -> ((Comparable)rec$).compareTo(x$0)).toList();
            ArrayList datasetList = new ArrayList(this.data.size());
            for (Map.Entry entry : datasetMap.entrySet()) {
                ArrayList<Number> datasetData = new ArrayList<Number>(xValues.size());
                Map dataset = (Map)entry.getValue();
                for (Number xValue : xValues) {
                    Number yValue = (Number)dataset.get(xValue);
                    datasetData.add(yValue);
                }
                datasetList.add(new Dataset((String)entry.getKey(), datasetData, this.favoriteSet.contains(entry.getKey())));
            }
            return new LineChart(fileName, title, xLabel, yLabel, xValues, datasetList, stepped, timeOnX, timeOnY);
        }

        private Map<X, Y> largestTriangleThreeBuckets(NavigableMap<X, Y> datasetDataMap, int sampleSize) {
            if (datasetDataMap.size() <= sampleSize) {
                return datasetDataMap;
            }
            LinkedHashMap<Number, Number> sampled = new LinkedHashMap<Number, Number>(sampleSize);
            ArrayList keys = new ArrayList(datasetDataMap.keySet());
            double every = (double)(datasetDataMap.size() - 2) / (double)(sampleSize - 2);
            int a = 0;
            int nextA = 0;
            Number maxAreaPoint = null;
            datasetDataMap.entrySet().stream().findFirst().ifPresent(e -> sampled.put((Number)e.getKey(), (Number)e.getValue()));
            for (int i = 0; i < sampleSize - 2; ++i) {
                int avgRangeStart;
                double avgX = 0.0;
                double avgY = 0.0;
                int avgRangeEnd = (int)Math.floor((double)(i + 2) * every) + 1;
                avgRangeEnd = Math.min(avgRangeEnd, datasetDataMap.size());
                int avgRangeLength = avgRangeEnd - avgRangeStart;
                for (avgRangeStart = (int)Math.floor((double)(i + 1) * every) + 1; avgRangeStart < avgRangeEnd; ++avgRangeStart) {
                    avgX += ((Number)keys.get(avgRangeStart)).doubleValue();
                    avgY += ((Number)datasetDataMap.get(keys.get(avgRangeStart))).doubleValue();
                }
                avgX /= (double)avgRangeLength;
                avgY /= (double)avgRangeLength;
                int rangeTo = (int)Math.floor((double)(i + 1) * every) + 1;
                double pointAX = ((Number)keys.get(a)).doubleValue();
                double pointAY = ((Number)datasetDataMap.get(keys.get(a))).doubleValue();
                double maxArea = -1.0;
                for (int rangeOffs = (int)Math.floor((double)i * every) + 1; rangeOffs < rangeTo; ++rangeOffs) {
                    double area = Math.abs((pointAX - avgX) * (((Number)datasetDataMap.get(keys.get(rangeOffs))).doubleValue() - pointAY) - (pointAX - ((Number)keys.get(rangeOffs)).doubleValue()) * (avgY - pointAY)) * 0.5;
                    if (!(area > maxArea)) continue;
                    maxArea = area;
                    maxAreaPoint = (Number)datasetDataMap.get(keys.get(rangeOffs));
                    nextA = rangeOffs;
                }
                sampled.put((Number)keys.get(nextA), maxAreaPoint);
                a = nextA;
            }
            sampled.put((Number)keys.get(keys.size() - 1), (Number)datasetDataMap.get(keys.get(keys.size() - 1)));
            return sampled;
        }
    }
}

