/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.config.blueprint;

import ai.timefold.solver.benchmark.config.SolverBenchmarkConfig;
import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicType;
import ai.timefold.solver.core.config.localsearch.LocalSearchPhaseConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchType;
import ai.timefold.solver.core.config.solver.SolverConfig;
import jakarta.xml.bind.annotation.XmlEnum;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlEnum
public enum SolverBenchmarkBluePrintType {
    CONSTRUCTION_HEURISTIC_WITH_AND_WITHOUT_LOCAL_SEARCH,
    EVERY_CONSTRUCTION_HEURISTIC_TYPE,
    EVERY_LOCAL_SEARCH_TYPE,
    EVERY_CONSTRUCTION_HEURISTIC_TYPE_WITH_EVERY_LOCAL_SEARCH_TYPE;


    @NonNull List<SolverBenchmarkConfig> buildSolverBenchmarkConfigList() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case CONSTRUCTION_HEURISTIC_WITH_AND_WITHOUT_LOCAL_SEARCH -> this.buildConstructionHeuristicWithAndWithoutLocalSearch();
            case EVERY_CONSTRUCTION_HEURISTIC_TYPE -> this.buildEveryConstructionHeuristicType();
            case EVERY_LOCAL_SEARCH_TYPE -> this.buildEveryLocalSearchType();
            case EVERY_CONSTRUCTION_HEURISTIC_TYPE_WITH_EVERY_LOCAL_SEARCH_TYPE -> this.buildEveryConstructionHeuristicTypeWithEveryLocalSearchType();
        };
    }

    private List<SolverBenchmarkConfig> buildConstructionHeuristicWithAndWithoutLocalSearch() {
        ArrayList<SolverBenchmarkConfig> solverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(2);
        solverBenchmarkConfigList.add(this.buildSolverBenchmarkConfig(null, false, null));
        solverBenchmarkConfigList.add(this.buildSolverBenchmarkConfig(null, true, null));
        return solverBenchmarkConfigList;
    }

    private List<SolverBenchmarkConfig> buildEveryConstructionHeuristicType() {
        ConstructionHeuristicType[] chTypes = ConstructionHeuristicType.getBluePrintTypes();
        ArrayList<SolverBenchmarkConfig> solverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(chTypes.length);
        for (ConstructionHeuristicType chType : chTypes) {
            solverBenchmarkConfigList.add(this.buildSolverBenchmarkConfig(chType, false, null));
        }
        return solverBenchmarkConfigList;
    }

    private List<SolverBenchmarkConfig> buildEveryLocalSearchType() {
        return this.buildEveryLocalSearchType(null);
    }

    private List<SolverBenchmarkConfig> buildEveryLocalSearchType(ConstructionHeuristicType constructionHeuristicType) {
        LocalSearchType[] lsTypes = LocalSearchType.getBluePrintTypes();
        ArrayList<SolverBenchmarkConfig> solverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(lsTypes.length);
        for (LocalSearchType lsType : lsTypes) {
            if (lsType == LocalSearchType.DIVERSIFIED_LATE_ACCEPTANCE) continue;
            solverBenchmarkConfigList.add(this.buildSolverBenchmarkConfig(constructionHeuristicType, true, lsType));
        }
        return solverBenchmarkConfigList;
    }

    private List<SolverBenchmarkConfig> buildEveryConstructionHeuristicTypeWithEveryLocalSearchType() {
        ConstructionHeuristicType[] chTypes = ConstructionHeuristicType.getBluePrintTypes();
        LocalSearchType[] lsTypes = LocalSearchType.getBluePrintTypes();
        ArrayList<SolverBenchmarkConfig> solverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(chTypes.length * lsTypes.length);
        for (ConstructionHeuristicType chType : chTypes) {
            solverBenchmarkConfigList.addAll(this.buildEveryLocalSearchType(chType));
        }
        return solverBenchmarkConfigList;
    }

    private @NonNull SolverBenchmarkConfig buildSolverBenchmarkConfig(@Nullable ConstructionHeuristicType constructionHeuristicType, boolean localSearchEnabled, @Nullable LocalSearchType localSearchType) {
        String name;
        String constructionHeuristicName;
        SolverBenchmarkConfig solverBenchmarkConfig = new SolverBenchmarkConfig();
        String string = constructionHeuristicName = constructionHeuristicType == null ? "Construction Heuristic" : constructionHeuristicType.name();
        if (!localSearchEnabled) {
            name = constructionHeuristicName;
        } else {
            String localSearchName = localSearchType == null ? "Local Search" : localSearchType.name();
            name = constructionHeuristicType == null ? localSearchName : constructionHeuristicName + " - " + localSearchName;
        }
        solverBenchmarkConfig.setName(name);
        SolverConfig solverConfig = new SolverConfig();
        ArrayList<Object> phaseConfigList = new ArrayList<Object>(2);
        ConstructionHeuristicPhaseConfig constructionHeuristicPhaseConfig = new ConstructionHeuristicPhaseConfig();
        if (constructionHeuristicType != null) {
            constructionHeuristicPhaseConfig.setConstructionHeuristicType(constructionHeuristicType);
        }
        phaseConfigList.add(constructionHeuristicPhaseConfig);
        if (localSearchEnabled) {
            LocalSearchPhaseConfig localSearchPhaseConfig = new LocalSearchPhaseConfig();
            if (localSearchType != null) {
                localSearchPhaseConfig.setLocalSearchType(localSearchType);
            }
            phaseConfigList.add(localSearchPhaseConfig);
        }
        solverConfig.setPhaseConfigList(phaseConfigList);
        solverBenchmarkConfig.setSolverConfig(solverConfig);
        return solverBenchmarkConfig;
    }
}

