/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.api;

import ai.timefold.solver.benchmark.api.PlannerBenchmark;
import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import ai.timefold.solver.benchmark.impl.DefaultPlannerBenchmarkFactory;
import ai.timefold.solver.core.config.solver.SolverConfig;
import java.io.File;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class PlannerBenchmarkFactory {
    public static @NonNull PlannerBenchmarkFactory createFromSolverConfigXmlResource(@NonNull String solverConfigResource) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromSolverConfigXmlResource(@NonNull String solverConfigResource, @Nullable ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource, (ClassLoader)classLoader);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromSolverConfigXmlResource(@NonNull String solverConfigResource, @NonNull File benchmarkDirectory) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, benchmarkDirectory);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromSolverConfigXmlResource(@NonNull String solverConfigResource, @NonNull File benchmarkDirectory, @Nullable ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource, (ClassLoader)classLoader);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, benchmarkDirectory);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromXmlResource(@NonNull String benchmarkConfigResource) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromXmlResource(@NonNull String benchmarkConfigResource, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromXmlFile(@NonNull File benchmarkConfigFile) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlFile(benchmarkConfigFile);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromXmlFile(@NonNull File benchmarkConfigFile, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlFile(benchmarkConfigFile, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromFreemarkerXmlResource(@NonNull String templateResource) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromFreemarkerXmlResource(@NonNull String templateResource, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromFreemarkerXmlResource(@NonNull String templateResource, @Nullable Object model) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, model);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromFreemarkerXmlResource(@NonNull String templateResource, @Nullable Object model, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, model, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromFreemarkerXmlFile(@NonNull File templateFile) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromFreemarkerXmlFile(@NonNull File templateFile, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromFreemarkerXmlFile(@NonNull File templateFile, @Nullable Object model) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, model);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromFreemarkerXmlFile(@NonNull File templateFile, @Nullable Object model, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, model, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory create(@NonNull PlannerBenchmarkConfig benchmarkConfig) {
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromSolverConfig(@NonNull SolverConfig solverConfig) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig);
        return PlannerBenchmarkFactory.create(benchmarkConfig);
    }

    public static @NonNull PlannerBenchmarkFactory createFromSolverConfig(@NonNull SolverConfig solverConfig, @NonNull File benchmarkDirectory) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, benchmarkDirectory);
        return PlannerBenchmarkFactory.create(benchmarkConfig);
    }

    public abstract @NonNull PlannerBenchmark buildPlannerBenchmark();

    public <Solution_> @NonNull PlannerBenchmark buildPlannerBenchmark(@NonNull List<@NonNull Solution_> problemList) {
        return this.buildPlannerBenchmark(problemList.toArray());
    }

    public abstract <Solution_> @NonNull PlannerBenchmark buildPlannerBenchmark(Solution_ ... var1);
}

